/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResponseHeaders {
    public static final String LOCATION = "Location";
    public static final String X_REQUEST_ID = "X-Request-ID";
    public static final String ASPSP_SCA_APPROACH = "ASPSP-SCA-Approach";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String X_GTW_ASPSP_CHANGES_DETECTED = "X-GTW-ASPSP-CHANGES-DETECTED";
    private static Map<String, String> headerNamesLowerCased = new HashMap<String, String>();
    private Map<String, String> headers;

    private ResponseHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static ResponseHeaders fromMap(Map<String, String> headersMap) {
        if (Objects.isNull(headersMap) || headersMap.isEmpty()) {
            return ResponseHeaders.emptyResponseHeaders();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Set<String> headerNamesLowerCased = ResponseHeaders.headerNamesLowerCased.keySet();
        headersMap.forEach((name, value) -> {
            String headerNameInLowerCase = name.toLowerCase();
            if (ResponseHeaders.isHeaderExistInBGSpecification(headerNamesLowerCased, headerNameInLowerCase)) {
                headers.put(ResponseHeaders.headerNamesLowerCased.get(headerNameInLowerCase), (String)value);
            }
        });
        return new ResponseHeaders(headers);
    }

    public static ResponseHeaders emptyResponseHeaders() {
        return new ResponseHeaders(Collections.emptyMap());
    }

    private static boolean isHeaderExistInBGSpecification(Set<String> headerNames, String headerName) {
        return headerNames.contains(headerName);
    }

    public Map<String, String> getHeadersMap() {
        return new HashMap<String, String>(this.headers);
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    static {
        headerNamesLowerCased.put(LOCATION.toLowerCase(), LOCATION);
        headerNamesLowerCased.put(X_REQUEST_ID.toLowerCase(), X_REQUEST_ID);
        headerNamesLowerCased.put(ASPSP_SCA_APPROACH.toLowerCase(), ASPSP_SCA_APPROACH);
        headerNamesLowerCased.put(CONTENT_TYPE.toLowerCase(), CONTENT_TYPE);
        headerNamesLowerCased.put(X_GTW_ASPSP_CHANGES_DETECTED.toLowerCase(), X_GTW_ASPSP_CHANGES_DETECTED);
    }
}

