/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.api;

import de.adorsys.xs2a.adapter.api.exception.Xs2aAdapterException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class Pkcs12KeyStore {
    private static final String KEY_STORE_TYPE = "PKCS12";
    private static final String DEFAULT_QWAC_ALIAS = "default_qwac";
    private static final String DEFAULT_QSEAL_ALIAS = "default_qseal";
    private static final char[] DEFAULT_PASSWORD = new char[0];
    private static final String ORGANIZATION_IDENTIFIER_ATTRIBUTE = "OID.2.5.4.97";
    private final KeyStore keyStore = KeyStore.getInstance("PKCS12");
    private final char[] password;
    private final String defaultQwacAlias;
    private final String defaultQsealAlias;

    public Pkcs12KeyStore(String filename) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        this(filename, DEFAULT_PASSWORD);
    }

    public Pkcs12KeyStore(String filename, char[] password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        this(filename, password, DEFAULT_QWAC_ALIAS, DEFAULT_QSEAL_ALIAS);
    }

    public Pkcs12KeyStore(String filename, char[] password, String defaultQwacAlias, String defaultQsealAlias) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        this(new FileInputStream(filename), password, defaultQwacAlias, defaultQsealAlias);
    }

    public Pkcs12KeyStore(InputStream keyStore, char[] password, String defaultQwacAlias, String defaultQsealAlias) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        this.keyStore.load(Objects.requireNonNull(keyStore), password);
        this.password = password;
        this.defaultQwacAlias = defaultQwacAlias;
        this.defaultQsealAlias = defaultQsealAlias;
    }

    public Pkcs12KeyStore(InputStream keyStore) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this(keyStore, DEFAULT_PASSWORD, DEFAULT_QWAC_ALIAS, DEFAULT_QSEAL_ALIAS);
    }

    public SSLContext getSslContext() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, KeyManagementException, IOException, CertificateException {
        return this.getSslContext(null);
    }

    public SSLContext getSslContext(String qwacAlias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, KeyManagementException {
        if (qwacAlias == null) {
            qwacAlias = this.defaultQwacAlias;
        }
        KeyStore qwacKeyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        qwacKeyStore.load(null, this.password);
        KeyStore.Entry entry = this.keyStore.getEntry(qwacAlias, new KeyStore.PasswordProtection(this.password));
        qwacKeyStore.setEntry("", entry, new KeyStore.PasswordProtection(this.password));
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(qwacKeyStore, this.password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        sslContext.init(keyManagers, null, null);
        return sslContext;
    }

    public X509Certificate getQsealCertificate() throws KeyStoreException {
        return this.getQsealCertificate(null);
    }

    public X509Certificate getQsealCertificate(String qsealAlias) throws KeyStoreException {
        if (qsealAlias == null) {
            qsealAlias = this.defaultQsealAlias;
        }
        return (X509Certificate)this.keyStore.getCertificate(qsealAlias);
    }

    public PrivateKey getQsealPrivateKey() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        return this.getQsealPrivateKey(null);
    }

    public PrivateKey getQsealPrivateKey(String qsealAlias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (qsealAlias == null) {
            qsealAlias = this.defaultQsealAlias;
        }
        return (PrivateKey)this.keyStore.getKey(qsealAlias, this.password);
    }

    public String getOrganizationIdentifier() throws KeyStoreException {
        return this.getOrganizationIdentifier(null);
    }

    public String getOrganizationIdentifier(String qsealAlias) throws KeyStoreException {
        String name = this.getQsealCertificate(qsealAlias).getSubjectX500Principal().getName("RFC1779");
        try {
            return new LdapName(name).getRdns().stream().filter(rdn -> ORGANIZATION_IDENTIFIER_ATTRIBUTE.equals(rdn.getType())).map(rdn -> rdn.getValue().toString()).collect(Collectors.joining());
        }
        catch (InvalidNameException e) {
            throw new Xs2aAdapterException(e);
        }
    }
}

