/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.api;

import de.adorsys.xs2a.adapter.api.exception.Xs2aAdapterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public interface PkceOauth2Extension {
    public static byte[] random(int numBytes) {
        try {
            return SecureRandom.getInstanceStrong().generateSeed(numBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Xs2aAdapterException(e);
        }
    }

    default public byte[] octetSequence() {
        return StaticCodeVerifier.codeVerifier;
    }

    default public String codeVerifier() {
        return PkceOauth2Extension.base64urlNoPadding(this.octetSequence());
    }

    public static String base64urlNoPadding(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    default public String codeChallenge() {
        return PkceOauth2Extension.base64urlNoPadding(PkceOauth2Extension.sha256(this.codeVerifier().getBytes()));
    }

    public static byte[] sha256(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Xs2aAdapterException(e);
        }
    }

    public static class StaticCodeVerifier {
        private static final byte[] codeVerifier = PkceOauth2Extension.random(32);

        private StaticCodeVerifier() {
        }
    }
}

