/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum TransactionStatus {
    ACCC("AcceptedSettlementCompletedCreditor", true),
    ACCP("AcceptedCustomerProfile", false),
    ACSC("AcceptedSettlementCompleted", true),
    ACSP("AcceptedSettlementInProcess", false),
    ACTC("AcceptedTechnicalValidation", false),
    ACWC("AcceptedWithChange", false),
    ACWP("AcceptedWithoutPosting", false),
    RCVD("Received", false),
    PDNG("Pending", false),
    RJCT("Rejected", true),
    CANC("Canceled", true),
    ACFC("AcceptedFundsChecked", false),
    PATC("PartiallyAcceptedTechnicalCorrect", false),
    PART("PART", false);

    private static Map<String, TransactionStatus> container;
    private String transactionStatus;
    private final boolean finalisedStatus;

    public boolean isFinalisedStatus() {
        return this.finalisedStatus;
    }

    public boolean isNotFinalisedStatus() {
        return !this.isFinalisedStatus();
    }

    private TransactionStatus(String transactionStatus, boolean finalisedStatus) {
        this.transactionStatus = transactionStatus;
        this.finalisedStatus = finalisedStatus;
    }

    public static TransactionStatus getByValue(String transactionStatus) {
        return container.get(transactionStatus);
    }

    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public String toString() {
        return this.transactionStatus;
    }

    static {
        container = new HashMap<String, TransactionStatus>();
        Arrays.stream(TransactionStatus.values()).forEach(status -> container.put(status.getTransactionStatus(), (TransactionStatus)((Object)status)));
    }
}

