/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.oauth;

import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.exception.BadRequestException;
import de.adorsys.xs2a.adapter.service.oauth.ParamAdjuster;
import de.adorsys.xs2a.adapter.service.oauth.ParamAdjustingResultHolder;

public interface OauthParamsAdjustingService {
    public static final String QUERY_PARAMETERS_MISSING_ERROR_MESSAGE = "The following query parameters are missing or not valid: %s";

    public Oauth2Service.Parameters adjustForGetAuthorizationRequest(Oauth2Service.Parameters var1);

    public Oauth2Service.Parameters adjustForGetTokenRequest(Oauth2Service.Parameters var1);

    public Oauth2Service.Parameters adjustForRefreshTokenRequest(Oauth2Service.Parameters var1);

    default public Oauth2Service.Parameters adjustParams(Oauth2Service.Parameters parametersFromTpp, ParamAdjuster paramAdjuster) {
        ParamAdjustingResultHolder adjustingResult = paramAdjuster.adjustParam(new ParamAdjustingResultHolder(), parametersFromTpp);
        if (adjustingResult.containsMissingParams()) {
            throw new BadRequestException(String.format(QUERY_PARAMETERS_MISSING_ERROR_MESSAGE, adjustingResult.getMissingParameters()));
        }
        return new Oauth2Service.Parameters(adjustingResult.getParametersMap());
    }
}

