/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ScaStatus {
    RECEIVED("received", false),
    PSUIDENTIFIED("psuIdentified", false),
    PSUAUTHENTICATED("psuAuthenticated", false),
    SCAMETHODSELECTED("scaMethodSelected", false),
    STARTED("started", false),
    FINALISED("finalised", true),
    FAILED("failed", true),
    EXEMPTED("exempted", false);

    private static final Map<String, ScaStatus> HOLDER;
    private String value;
    private final boolean finalisedStatus;

    private ScaStatus(String value, boolean finalisedStatus) {
        this.value = value;
        this.finalisedStatus = finalisedStatus;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public boolean isFinalisedStatus() {
        return this.finalisedStatus;
    }

    public boolean isNotFinalisedStatus() {
        return !this.isFinalisedStatus();
    }

    @JsonCreator
    public static ScaStatus fromValue(String text) {
        for (ScaStatus scaStatus : ScaStatus.values()) {
            if (!String.valueOf(scaStatus.value).equals(text)) continue;
            return scaStatus;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    static {
        HOLDER = new HashMap<String, ScaStatus>();
        for (ScaStatus status : ScaStatus.values()) {
            HOLDER.put(status.value.toLowerCase(), status);
        }
    }
}

