/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum CashAccountType {
    CACC("Current"),
    CASH("CashPayment"),
    CHAR("Charges"),
    CISH("CashIncome"),
    COMM("Commission"),
    CPAC("ClearingParticipantSettlementAccount"),
    LLSV("LimitedLiquiditySavingsAccount"),
    LOAN("Loan"),
    MGLD("Marginal Lending"),
    MOMA("Money Market"),
    NREX("NonResidentExternal"),
    ODFT("Overdraft"),
    ONDP("OverNightDeposit"),
    OTHR("OtherAccount"),
    SACC("Settlement"),
    SLRY("Salary"),
    SVGS("Savings"),
    TAXE("Tax"),
    TRAN("TransactingAccount"),
    TRAS("Cash Trading");

    private static final Map<String, CashAccountType> container;
    private String value;

    private CashAccountType(String value) {
        this.value = value;
    }

    public static Optional<CashAccountType> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    static {
        container = new HashMap<String, CashAccountType>();
        for (CashAccountType cashAccountType : CashAccountType.values()) {
            container.put(cashAccountType.getValue(), cashAccountType);
        }
    }
}

