/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum AccountStatus {
    ENABLED("enabled"),
    DELETED("deleted"),
    BLOCKED("blocked");

    private static final Map<String, AccountStatus> container;
    private String value;

    private AccountStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<AccountStatus> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        container = new HashMap<String, AccountStatus>();
        for (AccountStatus accountStatus : AccountStatus.values()) {
            container.put(accountStatus.getValue(), accountStatus);
        }
    }
}

