/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service;

import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Oauth2Service {
    public URI getAuthorizationRequestUri(Map<String, String> var1, Parameters var2) throws IOException;

    public TokenResponse getToken(Map<String, String> var1, Parameters var2) throws IOException;

    public static enum ResponseType {
        CODE("code");

        private final String value;

        private ResponseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum GrantType {
        AUTHORIZATION_CODE("authorization_code"),
        REFRESH_TOKEN("refresh_token");

        private final String value;

        private GrantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Parameters {
        public static final String CODE = "code";
        public static final String REFRESH_TOKEN = "refresh_token";
        public static final String GRANT_TYPE = "grant_type";
        public static final String REDIRECT_URI = "redirect_uri";
        public static final String CLIENT_ID = "client_id";
        public static final String STATE = "state";
        public static final String SCOPE = "scope";
        public static final String RESPONSE_TYPE = "response_type";
        public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
        public static final String CODE_CHALLENGE = "code_challenge";
        public static final String CODE_VERIFIER = "code_verifier";
        public static final String BIC = "bic";
        public static final String CONSENT_ID = "consent_id";
        public static final String PAYMENT_ID = "payment_id";
        public static final String SCA_OAUTH_LINK = "sca_oauth_link";
        public static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        public static final String TOKEN_ENDPOINT = "token_endpoint";
        private final Map<String, String> parameters;

        public Parameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public Parameters() {
            this(new LinkedHashMap<String, String>());
        }

        public Map<String, String> asMap() {
            return this.parameters;
        }

        public String get(String key) {
            return this.parameters.get(key);
        }

        public void set(String key, String value) {
            if (key != null && value != null) {
                this.parameters.put(key, value);
            }
        }

        public String remove(String key) {
            return this.parameters.remove(key);
        }

        public String getAuthorizationCode() {
            return this.get(CODE);
        }

        public void setAuthorizationCode(String value) {
            this.set(CODE, value);
        }

        public String getRedirectUri() {
            return this.get(REDIRECT_URI);
        }

        public void setRedirectUri(String value) {
            this.set(REDIRECT_URI, value);
        }

        public String getClientId() {
            return this.get(CLIENT_ID);
        }

        public void setClientId(String value) {
            this.set(CLIENT_ID, value);
        }

        public String getGrantType() {
            return this.get(GRANT_TYPE);
        }

        public void setGrantType(String value) {
            this.set(GRANT_TYPE, value);
        }

        public String getCodeVerifier() {
            return this.get(CODE_VERIFIER);
        }

        public void setCodeVerifier(String value) {
            this.set(CODE_VERIFIER, value);
        }

        public String getState() {
            return this.get(STATE);
        }

        public void setState(String value) {
            this.set(STATE, value);
        }

        public String getScaOAuthLink() {
            return this.get(SCA_OAUTH_LINK);
        }

        public void setScaOAuthLink(String value) {
            this.set(SCA_OAUTH_LINK, value);
        }

        public String removeScaOAuthLink() {
            return this.remove(SCA_OAUTH_LINK);
        }

        public String getBic() {
            return this.get(BIC);
        }

        public void setBic(String value) {
            this.set(BIC, value);
        }

        public String getScope() {
            return this.get(SCOPE);
        }

        public void setScope(String value) {
            this.set(SCOPE, value);
        }

        public String getResponseType() {
            return this.get(RESPONSE_TYPE);
        }

        public void setResponseType(String value) {
            this.set(RESPONSE_TYPE, value);
        }

        public String getCodeChallenge() {
            return this.get(CODE_CHALLENGE);
        }

        public void setCodeChallenge(String value) {
            this.set(CODE_CHALLENGE, value);
        }

        public String getCodeChallengeMethod() {
            return this.get(CODE_CHALLENGE_METHOD);
        }

        public void setCodeChallengeMethod(String value) {
            this.set(CODE_CHALLENGE_METHOD, value);
        }

        public String getRefreshToken() {
            return this.get(REFRESH_TOKEN);
        }

        public void setRefreshToken(String value) {
            this.set(REFRESH_TOKEN, value);
        }

        public String getConsentId() {
            return this.get(CONSENT_ID);
        }

        public void setConsentId(String value) {
            this.set(CONSENT_ID, value);
        }

        public String getPaymentId() {
            return this.get(PAYMENT_ID);
        }

        public void setPaymentId(String value) {
            this.set(PAYMENT_ID, value);
        }

        public String getAuthorizationEndpoint() {
            return this.get(AUTHORIZATION_ENDPOINT);
        }

        public void setAuthorizationEndpoint(String value) {
            this.set(AUTHORIZATION_ENDPOINT, value);
        }

        public String getTokenEndpoint() {
            return this.get(TOKEN_ENDPOINT);
        }

        public void setTokenEndpoint(String value) {
            this.set(TOKEN_ENDPOINT, value);
        }

        public String removeTokenEndpoint() {
            return this.remove(TOKEN_ENDPOINT);
        }
    }
}

