/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.signing.header;

import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.signing.service.algorithm.EncodingAlgorithm;
import de.adorsys.xs2a.adapter.signing.service.algorithm.SigningAlgorithm;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Signature {
    private String headerValue;

    private Signature(String headerValue) {
        this.headerValue = headerValue;
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }

    public String getHeaderName() {
        return "Signature";
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public static final class SignatureBuilder {
        private String keyId;
        private SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256_WITH_RSA;
        private EncodingAlgorithm encodingAlgorithm = EncodingAlgorithm.BASE64;
        private Charset charset = StandardCharsets.UTF_8;
        private Map<String, String> headersMap;
        private PrivateKey privateKey;

        private SignatureBuilder() {
        }

        public SignatureBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public SignatureBuilder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public SignatureBuilder encodingAlgorithm(EncodingAlgorithm encodingAlgorithm) {
            this.encodingAlgorithm = encodingAlgorithm;
            return this;
        }

        public SignatureBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public SignatureBuilder headers(Map<String, String> headers) {
            this.headersMap = new HashMap<String, String>(headers);
            return this;
        }

        public SignatureBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Signature build() {
            if (this.privateKeyNotExist()) {
                throw new HttpRequestSigningException("Private key is missing: it is impossible to create a signature without such a key");
            }
            if (this.requiredAttributesNotExist()) {
                throw new HttpRequestSigningException(String.format("Required Signature header attributes must be present. Current values [%s] = %s, [%s] = %s, [%s] = %s)", new Object[]{"keyId", this.keyId, "algorithm", this.signingAlgorithm, "headers", this.headersMap}));
            }
            List<Map.Entry<String, String>> headersEntries = this.getSortedHeaderEntries(this.headersMap);
            String headersAttributeValue = this.buildHeaderAttributeValue(headersEntries);
            String signingString = this.buildSigningString(headersEntries);
            byte[] signedData = this.signingAlgorithm.getSigningService().sign(this.privateKey, signingString, this.charset);
            String signatureAttributeValue = this.encodingAlgorithm.getEncodingService().encode(signedData);
            return new Signature(this.buildSignatureHeader(this.keyId, this.signingAlgorithm.getAlgorithmName(), headersAttributeValue, signatureAttributeValue));
        }

        private boolean privateKeyNotExist() {
            return this.privateKey == null;
        }

        private boolean requiredAttributesNotExist() {
            return this.keyId == null || this.keyId.isEmpty() || this.signingAlgorithm == null || this.headersMap == null || this.headersMap.isEmpty();
        }

        private List<Map.Entry<String, String>> getSortedHeaderEntries(Map<String, String> headersMap) {
            return headersMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        }

        private String buildHeaderAttributeValue(List<Map.Entry<String, String>> headersEntries) {
            return headersEntries.stream().map(Map.Entry::getKey).map(String::toLowerCase).collect(Collectors.joining(" "));
        }

        private String buildSigningString(List<Map.Entry<String, String>> headersEntries) {
            return headersEntries.stream().map(entry -> this.buildSigningLine((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.joining("\n"));
        }

        private String buildSigningLine(String headerName, String headerValue) {
            return headerName.toLowerCase() + ":" + " " + headerValue;
        }

        private String buildSignatureHeader(String keyIdAttributeValue, String algorithmAttributeValue, String headersAttributeValue, String signatureAttributeValue) {
            return this.buildAttribute("keyId", keyIdAttributeValue) + "," + this.buildAttribute("algorithm", algorithmAttributeValue) + "," + this.buildAttribute("headers", headersAttributeValue) + "," + this.buildAttribute("signature", signatureAttributeValue);
        }

        private String buildAttribute(String attributeName, String attributeValue) {
            return attributeName + "=" + "\"" + attributeValue + "\"";
        }
    }
}

