/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.signing;

import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.signing.header.Digest;
import de.adorsys.xs2a.adapter.signing.header.Signature;
import de.adorsys.xs2a.adapter.signing.header.TppSignatureCertificate;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;

public class RequestSigningService {
    private final Pkcs12KeyStore keyStore;

    public RequestSigningService(Pkcs12KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public Digest buildDigest(String requestBody) {
        return Digest.builder().requestBody(requestBody).build();
    }

    public Signature buildSignature(Map<String, String> headersMap) {
        return Signature.builder().keyId(this.getKeyId()).headers(headersMap).privateKey(this.getPrivateKey()).build();
    }

    private String getKeyId() {
        X509Certificate certificate = this.getCertificate();
        return "SN=" + certificate.getSerialNumber().toString(16) + "," + "CA" + "=" + certificate.getIssuerX500Principal().getName().replaceAll(" ", "%20");
    }

    private X509Certificate getCertificate() {
        X509Certificate certificate = null;
        try {
            certificate = this.keyStore.getQsealCertificate();
        }
        catch (KeyStoreException e) {
            throw new HttpRequestSigningException((Throwable)e);
        }
        return certificate;
    }

    private PrivateKey getPrivateKey() {
        try {
            return this.keyStore.getQsealPrivateKey();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new HttpRequestSigningException((Throwable)e);
        }
    }

    public TppSignatureCertificate buildTppSignatureCertificate() {
        return TppSignatureCertificate.builder().publicKeyAsString(this.getPublicKeyAsString()).build();
    }

    private String getPublicKeyAsString() {
        X509Certificate certificate = this.getCertificate();
        try {
            return Base64.getEncoder().encodeToString(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new HttpRequestSigningException((Throwable)e);
        }
    }
}

