/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.JsonMapper;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import de.adorsys.xs2a.adapter.service.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.service.exception.NotAcceptableException;
import de.adorsys.xs2a.adapter.service.model.ErrorResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlers {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([^;]+)");
    private static final ErrorResponse EMPTY_ERROR_RESPONSE = new ErrorResponse();
    private static final JsonMapper jsonMapper = new JsonMapper();
    private static final Logger log = LoggerFactory.getLogger(ResponseHandlers.class);

    private ResponseHandlers() {
    }

    public static <T> HttpClient.ResponseHandler<T> jsonResponseHandler(Class<T> klass) {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 204) {
                return null;
            }
            PushbackInputStream pushbackResponseBody = new PushbackInputStream(responseBody);
            String contentType = responseHeaders.getHeader("Content-Type");
            if (statusCode >= 400) {
                if ((contentType == null || !contentType.startsWith("application/json")) && ResponseHandlers.isNotJson(pushbackResponseBody)) {
                    throw ResponseHandlers.responseException(statusCode, pushbackResponseBody, responseHeaders, ResponseHandlers::buildEmptyErrorResponse);
                }
                throw ResponseHandlers.responseException(statusCode, pushbackResponseBody, responseHeaders, ResponseHandlers::buildErrorResponseFromString);
            }
            if (contentType != null && !contentType.startsWith("application/json")) {
                throw new NotAcceptableException(String.format("Content type %s is not acceptable, has to start with %s", contentType, "application/json"));
            }
            if (statusCode == 200 || statusCode == 201) {
                return jsonMapper.readValue(responseBody, klass);
            }
            throw ResponseHandlers.responseException(statusCode, pushbackResponseBody, responseHeaders, ResponseHandlers::buildErrorResponseFromString);
        };
    }

    private static boolean isNotJson(PushbackInputStream responseBody) {
        try {
            int data = responseBody.read();
            responseBody.unread(data);
            if (data != -1) {
                char firstChar = (char)data;
                return firstChar != '{';
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ErrorResponseException responseException(int statusCode, PushbackInputStream responseBody, ResponseHeaders responseHeaders, Function<String, ErrorResponse> errorResponseBuilder) {
        if (ResponseHandlers.isEmpty(responseBody)) {
            return new ErrorResponseException(statusCode, responseHeaders);
        }
        String originalResponse = ResponseHandlers.toString(responseBody, responseHeaders);
        ErrorResponse errorResponse = errorResponseBuilder.apply(originalResponse);
        return new ErrorResponseException(statusCode, responseHeaders, errorResponse, originalResponse);
    }

    private static ErrorResponse buildErrorResponseFromString(String originalResponse) {
        return jsonMapper.readValue(originalResponse, ErrorResponse.class);
    }

    private static ErrorResponse buildEmptyErrorResponse(String originalResponse) {
        return EMPTY_ERROR_RESPONSE;
    }

    private static boolean isEmpty(PushbackInputStream responseBody) {
        try {
            int nextByte = responseBody.read();
            if (nextByte == -1) {
                return true;
            }
            responseBody.unread(nextByte);
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static HttpClient.ResponseHandler<String> stringResponseHandler() {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 200) {
                return ResponseHandlers.toString(responseBody, responseHeaders);
            }
            throw ResponseHandlers.responseException(statusCode, new PushbackInputStream(responseBody), responseHeaders, ResponseHandlers::buildEmptyErrorResponse);
        };
    }

    public static HttpClient.ResponseHandler<byte[]> byteArrayResponseHandler() {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 200) {
                return ResponseHandlers.toByteArray(responseBody);
            }
            throw ResponseHandlers.responseException(statusCode, new PushbackInputStream(responseBody), responseHeaders, ResponseHandlers::buildEmptyErrorResponse);
        };
    }

    private static String toString(InputStream responseBody, ResponseHeaders responseHeaders) {
        Matcher matcher;
        String charset = StandardCharsets.UTF_8.name();
        String contentType = responseHeaders.getHeader("Content-Type");
        if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
            charset = matcher.group(1);
        }
        log.debug("{} charset will be used for response body parsing", (Object)charset);
        try {
            return ResponseHandlers.readResponseBodyAsByteArrayOutputStream(responseBody).toString(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] toByteArray(InputStream responseBody) {
        return ResponseHandlers.readResponseBodyAsByteArrayOutputStream(responseBody).toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteArrayOutputStream readResponseBodyAsByteArrayOutputStream(InputStream responseBody) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = responseBody.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            ByteArrayOutputStream byteArrayOutputStream = baos;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

