/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.signing.RequestSigningService;
import de.adorsys.xs2a.adapter.signing.header.Digest;
import de.adorsys.xs2a.adapter.signing.header.Signature;
import de.adorsys.xs2a.adapter.signing.header.TppSignatureCertificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestSigningInterceptor
implements Request.Builder.Interceptor {
    private static final List<String> SIGNATURE_HEADERS = Arrays.asList("Digest", "X-Request-ID", "PSU-ID", "PSU-Corporate-ID", "Date", "TPP-Redirect-URI");
    private final RequestSigningService requestSigningService;

    public RequestSigningInterceptor(Pkcs12KeyStore keyStore) {
        this.requestSigningService = new RequestSigningService(keyStore);
    }

    public Request.Builder apply(Request.Builder requestBuilder) {
        this.populateDigest(requestBuilder);
        this.populateSignature(requestBuilder);
        this.populateTppSignatureCertificate(requestBuilder);
        return requestBuilder;
    }

    private void populateDigest(Request.Builder requestBuilder) {
        String requestBody = requestBuilder.jsonBody();
        if (requestBody == null) {
            requestBody = "";
        }
        Digest digest = this.requestSigningService.buildDigest(requestBody);
        requestBuilder.header(digest.getHeaderName(), digest.getHeaderValue());
    }

    private void populateSignature(Request.Builder requestBuilder) {
        Map<String, String> headersMap = requestBuilder.headers().entrySet().stream().filter(e -> SIGNATURE_HEADERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Signature signature = this.requestSigningService.buildSignature(headersMap);
        requestBuilder.header(signature.getHeaderName(), signature.getHeaderValue());
    }

    private void populateTppSignatureCertificate(Request.Builder requestBuilder) {
        TppSignatureCertificate tppSignatureCertificate = this.requestSigningService.buildTppSignatureCertificate();
        requestBuilder.header(tppSignatureCertificate.getHeaderName(), tppSignatureCertificate.getHeaderValue());
    }
}

