/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.ApacheHttpClient;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheHttpClientFactory
implements HttpClientFactory {
    private final HttpClientBuilder httpClientBuilder;
    private final Pkcs12KeyStore keyStore;
    private final ConcurrentMap<String, HttpClient> cache = new ConcurrentHashMap<String, HttpClient>();

    public ApacheHttpClientFactory(HttpClientBuilder httpClientBuilder, Pkcs12KeyStore keyStore) {
        this.httpClientBuilder = httpClientBuilder;
        this.keyStore = keyStore;
    }

    public HttpClient getHttpClient(String adapterId, String qwacAlias, String[] supportedCipherSuites) {
        return this.cache.computeIfAbsent(adapterId, key -> this.createHttpClient(qwacAlias, supportedCipherSuites));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient createHttpClient(String qwacAlias, String[] supportedCipherSuites) {
        ApacheHttpClientFactory apacheHttpClientFactory = this;
        synchronized (apacheHttpClientFactory) {
            SSLContext sslContext = this.getSslContext(qwacAlias);
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(socketFactory, null, supportedCipherSuites, (HostnameVerifier)null);
            this.httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            CloseableHttpClient httpClient = this.httpClientBuilder.build();
            return new ApacheHttpClient(httpClient);
        }
    }

    private SSLContext getSslContext(String qwacAlias) {
        try {
            return this.keyStore.getSslContext(qwacAlias);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

