/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.signing.storage;

import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class KeyStorageService {
    private static final KeyStorageService KEY_STORAGE_SERVICE = new KeyStorageService();
    private String privateKeyPath;
    private String privateKeyPassword;
    private String keyAlias;
    private KeyStore keystore;
    private X509Certificate certificate;
    private String publicKeyAsString;
    private PrivateKey privateKey;
    private String keyId;

    public static KeyStorageService getInstance() {
        return KEY_STORAGE_SERVICE;
    }

    private KeyStorageService() {
        this.initProperties();
        this.initKey();
        this.initAlias();
        this.initCertificate();
    }

    private void initProperties() {
        this.privateKeyPath = System.getProperty("javax.net.ssl.keyStore");
        this.privateKeyPassword = System.getProperty("javax.net.ssl.keyStorePassword");
    }

    private void initKey() {
        try {
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            if (keyStoreType == null) {
                throw new HttpRequestSigningException(String.format("Key store type system property [%s] is not provided", "javax.net.ssl.keyStoreType"));
            }
            this.keystore = KeyStore.getInstance(keyStoreType);
            this.keystore.load(new FileInputStream(new File(this.privateKeyPath)), this.privateKeyPassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new HttpRequestSigningException("Exception during the private key initialisation: " + e);
        }
    }

    private void initCertificate() {
        try {
            this.certificate = (X509Certificate)this.keystore.getCertificate(this.keyAlias);
        }
        catch (KeyStoreException e) {
            throw new HttpRequestSigningException("Exception during the public key initialisation: " + e);
        }
    }

    private void initAlias() {
        try {
            Enumeration<String> aliases = this.keystore.aliases();
            if (!aliases.hasMoreElements()) {
                throw new HttpRequestSigningException("Key store is empty");
            }
            String alias = aliases.nextElement();
            if (aliases.hasMoreElements()) {
                throw new HttpRequestSigningException("Key store contains more, than one key");
            }
            this.keyAlias = alias;
        }
        catch (KeyStoreException e) {
            throw new HttpRequestSigningException("Exception during the getting the aliases from the key store: " + e);
        }
    }

    public String getPublicKeyAsString() {
        if (this.publicKeyAsString == null) {
            try (StringWriter writer = new StringWriter();
                 JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
                pemWriter.writeObject((Object)this.certificate);
                pemWriter.flush();
                this.publicKeyAsString = writer.toString().replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\n", "").replaceAll("\r", "");
            }
            catch (IOException e) {
                throw new HttpRequestSigningException("Exception during the getting public key as a string: " + e);
            }
        }
        return this.publicKeyAsString;
    }

    public String getKeyId() {
        if (this.keyId == null) {
            this.keyId = "SN=" + this.certificate.getSerialNumber().toString(16) + "," + "CA" + "=" + this.certificate.getIssuerX500Principal().getName().replaceAll(" ", "%20");
        }
        return this.keyId;
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            try {
                this.privateKey = (PrivateKey)this.keystore.getKey(this.keyAlias, this.privateKeyPassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new HttpRequestSigningException(String.format("Exception during the key getting by alias [%s]: %s", this.keyAlias, e));
            }
        }
        return this.privateKey;
    }
}

