/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.signing.RequestSigningService;
import de.adorsys.xs2a.adapter.signing.header.Digest;
import de.adorsys.xs2a.adapter.signing.header.Signature;
import de.adorsys.xs2a.adapter.signing.header.TppSignatureCertificate;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class RequestSigningInterceptor
implements HttpRequestInterceptor {
    private static final List<String> SIGNATURE_HEADERS = Arrays.asList("Digest", "X-Request-ID", "PSU-ID", "PSU-Corporate-ID", "Date", "TPP-Redirect-URI");
    private final RequestSigningService requestSigningService = new RequestSigningService();

    public void process(HttpRequest request, HttpContext context) {
        this.populateDigest(request);
        this.populateSignature(request);
        this.populateTppSignatureCertificate(request);
    }

    private void populateDigest(HttpRequest request) {
        String requestBody = "";
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity requestEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            try {
                requestBody = EntityUtils.toString((HttpEntity)requestEntity);
            }
            catch (IOException e) {
                throw new HttpRequestSigningException("Exception during the request body reading: " + e);
            }
        }
        Digest digest = this.requestSigningService.buildDigest(requestBody);
        request.addHeader(digest.getHeaderName(), digest.getHeaderValue());
    }

    private void populateSignature(HttpRequest request) {
        Map<String, String> headersMap = SIGNATURE_HEADERS.stream().map(arg_0 -> ((HttpRequest)request).getHeaders(arg_0)).filter(headers -> ((Header[])headers).length > 0).map(headers -> headers[0]).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        Signature signature = this.requestSigningService.buildSignature(headersMap);
        request.addHeader(signature.getHeaderName(), signature.getHeaderValue());
    }

    private void populateTppSignatureCertificate(HttpRequest request) {
        TppSignatureCertificate tppSignatureCertificate = this.requestSigningService.buildTppSignatureCertificate();
        request.addHeader(tppSignatureCertificate.getHeaderName(), tppSignatureCertificate.getHeaderValue());
    }
}

