/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.adorsys.xs2a.adapter.http.Psd2DateTimeDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;

public class JsonMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonMapper() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.registerModule((Module)this.buildPsd2DateTimeDeserializerModule());
    }

    public String writeValueAsString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> T readValue(InputStream inputStream, Class<T> klass) {
        try {
            return (T)this.objectMapper.readValue(inputStream, klass);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T convertValue(Object value, Class<T> klass) {
        return (T)this.objectMapper.convertValue(value, klass);
    }

    private SimpleModule buildPsd2DateTimeDeserializerModule() {
        SimpleModule dateTimeModule = new SimpleModule();
        dateTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new Psd2DateTimeDeserializer());
        return dateTimeModule;
    }
}

