/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.ApacheHttpClient;
import de.adorsys.xs2a.adapter.http.HttpClientException;
import de.adorsys.xs2a.adapter.http.RequestSigningInterceptor;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;

public interface HttpClient {
    public <T> Response<T> post(String var1, String var2, Map<String, String> var3, ResponseHandler<T> var4);

    public <T> Response<T> post(String var1, Map<String, String> var2, ResponseHandler<T> var3);

    public <T> Response<T> postForm(String var1, Map<String, String> var2, Map<String, String> var3, ResponseHandler<T> var4);

    public <T> Response<T> get(String var1, Map<String, String> var2, ResponseHandler<T> var3);

    public <T> Response<T> put(String var1, String var2, Map<String, String> var3, ResponseHandler<T> var4);

    public <T> Response<T> delete(String var1, Map<String, String> var2, ResponseHandler<T> var3);

    public static HttpClient newHttpClient() {
        try {
            return new ApacheHttpClient(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpClientException(e);
        }
    }

    public static HttpClient newHttpClientWithSignature(RequestSigningInterceptor requestSigningInterceptor) {
        try {
            return new ApacheHttpClient(SSLContext.getDefault(), requestSigningInterceptor);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpClientException(e);
        }
    }

    @FunctionalInterface
    public static interface ResponseHandler<T> {
        public T apply(int var1, InputStream var2, ResponseHeaders var3);
    }
}

