/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.RequestSigningInterceptor;
import de.adorsys.xs2a.adapter.http.UserAgentRemovingInterceptor;
import de.adorsys.xs2a.adapter.service.Response;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

class ApacheHttpClient
implements HttpClient {
    private SSLContext sslContext;
    private RequestSigningInterceptor requestSigningInterceptor;
    private UserAgentRemovingInterceptor userAgentRemovingInterceptor = new UserAgentRemovingInterceptor();

    ApacheHttpClient(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    ApacheHttpClient(SSLContext sslContext, RequestSigningInterceptor requestSigningInterceptor) {
        this.sslContext = sslContext;
        this.requestSigningInterceptor = requestSigningInterceptor;
    }

    @Override
    public <T> Response<T> post(String uri, String body, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)post, headers, responseHandler);
    }

    @Override
    public <T> Response<T> post(String uri, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity("{}", ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)post, headers, responseHandler);
    }

    @Override
    public <T> Response<T> postForm(String uri, Map<String, String> headers, Map<String, String> params, HttpClient.ResponseHandler<T> responseHandler) {
        HttpPost post = new HttpPost(uri);
        List list = params.keySet().stream().map(key -> new BasicNameValuePair(key, (String)params.get(key))).collect(Collectors.toList());
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
        return this.execute((HttpUriRequest)post, headers, responseHandler);
    }

    @Override
    public <T> Response<T> get(String uri, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        return this.execute((HttpUriRequest)new HttpGet(uri), headers, responseHandler);
    }

    @Override
    public <T> Response<T> put(String uri, String body, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)put, headers, responseHandler);
    }

    @Override
    public <T> Response<T> delete(String uri, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        return this.execute((HttpUriRequest)new HttpDelete(uri), headers, responseHandler);
    }

    /*
     * Exception decompiling
     */
    private <T> Response<T> execute(HttpUriRequest request, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLContext(this.sslContext).addInterceptorLast((HttpRequestInterceptor)this.userAgentRemovingInterceptor);
        if (this.requestSigningInterceptor != null) {
            httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)this.requestSigningInterceptor);
        }
        return httpClientBuilder.build();
    }

    private Map<String, String> toHeadersMap(Header[] headers) {
        if (Objects.isNull(headers)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }
}

