/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.PaymentProduct;
import java.util.Arrays;

public enum StandardPaymentProduct implements PaymentProduct
{
    SEPA_CREDIT_TRANSFERS("sepa-credit-transfers", "application/json"),
    PAIN_SEPA_CREDIT_TRANSFERS("pain.001-sepa-credit-transfers", "application/xml");

    private final String slug;
    private final String mediaType;

    private StandardPaymentProduct(String slug, String mediaType) {
        this.slug = slug;
        this.mediaType = mediaType;
    }

    public static StandardPaymentProduct fromSlug(String slug) {
        return Arrays.stream(StandardPaymentProduct.values()).filter(p -> p.getSlug().equals(slug)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }
}

