/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.PaymentProduct;
import de.adorsys.xs2a.adapter.adapter.StandardPaymentProduct;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationAuthorisationResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationStatus;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationInformationWithStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import java.util.Map;
import java.util.function.Function;

public class BasePaymentInitiationService
extends AbstractService
implements PaymentInitiationService {
    private static final String V1 = "v1";
    private static final String PAYMENTS = "payments";
    private final String baseUri;

    public BasePaymentInitiationService(String baseUri) {
        this.baseUri = baseUri;
    }

    public Response<PaymentInitiationRequestResponse> initiateSinglePayment(String paymentProduct, RequestHeaders requestHeaders, Object body) {
        return this.initiateSinglePayment(StandardPaymentProduct.fromSlug(paymentProduct), body, requestHeaders, PaymentInitiationRequestResponse.class, Function.identity());
    }

    protected <T> Response<PaymentInitiationRequestResponse> initiateSinglePayment(StandardPaymentProduct paymentProduct, Object body, RequestHeaders requestHeaders, Class<T> klass, Function<T, PaymentInitiationRequestResponse> mapper) {
        String bodyString;
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        switch (paymentProduct.getMediaType()) {
            case "application/json": {
                bodyString = this.jsonMapper.writeValueAsString(this.jsonMapper.convertValue(body, this.getSinglePaymentInitiationBodyClass()));
                break;
            }
            case "application/xml": {
                bodyString = (String)body;
                headersMap.put("Content-Type", "application/xml");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported payment product media type");
            }
        }
        Response<T> response = this.httpClient.post(StringUri.fromElements(this.baseUri, V1, PAYMENTS, paymentProduct.getSlug()), bodyString, headersMap, this.jsonResponseHandler(klass));
        PaymentInitiationRequestResponse paymentInitiationRequestResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)paymentInitiationRequestResponse, response.getHeaders());
    }

    public Response<SinglePaymentInitiationInformationWithStatusResponse> getSinglePaymentInformation(String paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        return this.getSinglePaymentInformation(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders);
    }

    private Response<SinglePaymentInitiationInformationWithStatusResponse> getSinglePaymentInformation(StandardPaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        String uri = StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct.getSlug(), paymentId);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headersMap, this.jsonResponseHandler(SinglePaymentInitiationInformationWithStatusResponse.class));
    }

    public Response<PaymentInitiationScaStatusResponse> getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders) {
        throw new UnsupportedOperationException();
    }

    public Response<PaymentInitiationStatus> getSinglePaymentInitiationStatus(String paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        return this.getSinglePaymentInitiationStatus(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders);
    }

    private Response<PaymentInitiationStatus> getSinglePaymentInitiationStatus(StandardPaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        String uri = this.getSinglePaymentInitiationStatusUri(paymentProduct.getSlug(), paymentId);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headersMap, this.jsonResponseHandler(PaymentInitiationStatus.class));
    }

    public Response<String> getSinglePaymentInitiationStatusAsString(String paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        String uri = this.getSinglePaymentInitiationStatusUri(paymentProduct, paymentId);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headersMap, this.stringResponseHandler());
    }

    private String getSinglePaymentInitiationStatusUri(String paymentProduct, String paymentId) {
        return StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct, paymentId, "status");
    }

    public Response<PaymentInitiationAuthorisationResponse> getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, RequestHeaders requestHeaders) {
        throw new UnsupportedOperationException();
    }

    public Response<StartScaProcessResponse> startSinglePaymentAuthorisation(String paymentProduct, String paymentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.startSinglePaymentAuthorisation(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders, updatePsuAuthentication, StartScaProcessResponse.class, Function.identity());
    }

    protected <T> Response<StartScaProcessResponse> startSinglePaymentAuthorisation(PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        String uri = StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct.getSlug(), paymentId, "authorisations");
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response<T> response = this.httpClient.post(uri, body, headersMap, this.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.updatePaymentPsuData(paymentService, (PaymentProduct)StandardPaymentProduct.fromSlug(paymentProduct), paymentId, authorisationId, requestHeaders, updatePsuAuthentication, UpdatePsuAuthenticationResponse.class, Function.identity());
    }

    protected <T> Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(String paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, UpdatePsuAuthenticationResponse> mapper) {
        String uri = StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct.getSlug(), paymentId, "authorisations", authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)updatePsuAuthenticationResponse, response.getHeaders());
    }

    public Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.updatePaymentPsuData(paymentService, (PaymentProduct)StandardPaymentProduct.fromSlug(paymentProduct), paymentId, authorisationId, requestHeaders, selectPsuAuthenticationMethod, SelectPsuAuthenticationMethodResponse.class, Function.identity());
    }

    protected <T> Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(String paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod, Class<T> klass, Function<T, SelectPsuAuthenticationMethodResponse> mapper) {
        String uri = StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct.getSlug(), paymentId, "authorisations", authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(selectPsuAuthenticationMethod);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)selectPsuAuthenticationMethodResponse, response.getHeaders());
    }

    public Response<ScaStatusResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation) {
        return this.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, transactionAuthorisation, ScaStatusResponse.class, Function.identity());
    }

    protected <T> Response<ScaStatusResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation, Class<T> klass, Function<T, ScaStatusResponse> mapper) {
        String uri = this.getUpdatePaymentPsuDataUri(paymentService, paymentProduct, paymentId, authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(transactionAuthorisation);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        ScaStatusResponse scaStatusResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)scaStatusResponse, response.getHeaders());
    }

    protected String getUpdatePaymentPsuDataUri(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        return StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct, paymentId, "authorisations", authorisationId);
    }

    protected String getSinglePaymentBaseUri() {
        return StringUri.fromElements(this.getPaymentBaseUri(), PAYMENTS);
    }

    protected String getPaymentBaseUri() {
        return StringUri.fromElements(this.baseUri, V1);
    }
}

