/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import java.util.Map;
import java.util.function.Function;

public class BaseAccountInformationService
extends AbstractService
implements AccountInformationService {
    private static final String V1 = "v1";
    private static final String CONSENTS = "consents";
    private static final String ACCOUNTS = "accounts";
    private static final String TRANSACTIONS = "transactions";
    private static final String BALANCES = "balances";
    private final String baseUri;

    public BaseAccountInformationService(String baseUri) {
        this.baseUri = baseUri;
    }

    public Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, Consents body) {
        return this.createConsent(requestHeaders, body, ConsentCreationResponse.class, Function.identity());
    }

    protected <T> Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, Consents body, Class<T> klass, Function<T, ConsentCreationResponse> mapper) {
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        String bodyString = this.jsonMapper.writeValueAsString(this.jsonMapper.convertValue(body, Consents.class));
        Response<T> response = this.httpClient.post(this.getConsentBaseUri(), bodyString, headersMap, this.jsonResponseHandler(klass));
        ConsentCreationResponse creationResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)creationResponse, response.getHeaders());
    }

    public Response<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders) {
        return this.getConsentInformation(consentId, requestHeaders, ConsentInformation.class, Function.identity());
    }

    protected <T> Response<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders, Class<T> klass, Function<T, ConsentInformation> mapper) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        Response<T> response = this.httpClient.get(uri, headersMap, this.jsonResponseHandler(klass));
        ConsentInformation consentInformation = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)consentInformation, response.getHeaders());
    }

    public Response<Void> deleteConsent(String consentId, RequestHeaders requestHeaders) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId);
        Map<String, String> headersMap = this.populateDeleteHeaders(requestHeaders.toMap());
        return this.httpClient.delete(uri, headersMap, this.jsonResponseHandler(Void.class));
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, RequestHeaders requestHeaders) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "status");
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headersMap, this.jsonResponseHandler(ConsentStatusResponse.class));
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        return this.httpClient.post(uri, headersMap, this.jsonResponseHandler(StartScaProcessResponse.class));
    }

    protected <T> Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        Response<T> response = this.httpClient.post(uri, headersMap, this.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.startConsentAuthorisation(consentId, requestHeaders, updatePsuAuthentication, StartScaProcessResponse.class, Function.identity());
    }

    protected <T> Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response<T> response = this.httpClient.post(uri, body, headersMap, this.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, updatePsuAuthentication, UpdatePsuAuthenticationResponse.class, Function.identity());
    }

    protected <T> Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, UpdatePsuAuthenticationResponse> mapper) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)updatePsuAuthenticationResponse, response.getHeaders());
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, selectPsuAuthenticationMethod, SelectPsuAuthenticationMethodResponse.class, Function.identity());
    }

    protected <T> Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod, Class<T> klass, Function<T, SelectPsuAuthenticationMethodResponse> mapper) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(selectPsuAuthenticationMethod);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)selectPsuAuthenticationMethodResponse, response.getHeaders());
    }

    public Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, transactionAuthorisation, ScaStatusResponse.class, Function.identity());
    }

    protected <T> Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation, Class<T> klass, Function<T, ScaStatusResponse> mapper) {
        String uri = this.getUpdateConsentPsuDataUri(consentId, authorisationId);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(transactionAuthorisation);
        Response<T> response = this.httpClient.put(uri, body, headersMap, this.jsonResponseHandler(klass));
        ScaStatusResponse scaStatusResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)scaStatusResponse, response.getHeaders());
    }

    protected String getUpdateConsentPsuDataUri(String consentId, String authorisationId) {
        return StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
    }

    public Response<AccountListHolder> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        headersMap = this.addConsentIdHeader(headersMap);
        String uri = BaseAccountInformationService.buildUri(this.getAccountsBaseUri(), requestParams);
        return this.httpClient.get(uri, headersMap, this.jsonResponseHandler(AccountListHolder.class));
    }

    public Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getTransactionList(accountId, requestHeaders, requestParams, TransactionsReport.class, Function.identity());
    }

    private String getTransactionListUri(String accountId, RequestParams requestParams) {
        String uri = StringUri.fromElements(this.getAccountsBaseUri(), accountId, TRANSACTIONS);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        return uri;
    }

    protected <T> Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, TransactionsReport> mapper) {
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        headersMap.put("Accept", "application/json");
        String uri = this.getTransactionListUri(accountId, requestParams);
        Response<T> response = this.httpClient.get(uri, headersMap, this.jsonResponseHandler(klass));
        TransactionsReport transactionsReport = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)transactionsReport, response.getHeaders());
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        String uri = this.getTransactionListUri(accountId, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headers, this.stringResponseHandler());
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders) {
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri, headers, this.jsonResponseHandler(ScaStatusResponse.class));
    }

    public Response<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders) {
        return this.getBalances(accountId, requestHeaders, BalanceReport.class, Function.identity());
    }

    protected <T> Response<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders, Class<T> klass, Function<T, BalanceReport> mapper) {
        String uri = StringUri.fromElements(this.getAccountsBaseUri(), accountId, BALANCES);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response<T> response = this.httpClient.get(uri, headers, this.jsonResponseHandler(klass));
        BalanceReport balanceReport = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)balanceReport, response.getHeaders());
    }

    protected String getConsentBaseUri() {
        return StringUri.fromElements(this.baseUri, V1, CONSENTS);
    }

    protected String getAccountsBaseUri() {
        return StringUri.fromElements(this.baseUri, V1, ACCOUNTS);
    }
}

