/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.JsonMapper;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import de.adorsys.xs2a.adapter.service.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.service.exception.NotAcceptableException;
import de.adorsys.xs2a.adapter.service.model.ErrorResponse;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService {
    private static final Logger log = LoggerFactory.getLogger(AbstractService.class);
    protected static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([^;]+)");
    protected static final String AUTHORISATIONS = "authorisations";
    protected static final String STATUS = "status";
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String ACCEPT_HEADER = "Accept";
    protected final JsonMapper jsonMapper = new JsonMapper();
    protected HttpClient httpClient = HttpClient.newHttpClient();

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected Map<String, String> addConsentIdHeader(Map<String, String> headers) {
        return headers;
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        return headers;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        return headers;
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        return headers;
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        return headers;
    }

    protected <T> HttpClient.ResponseHandler<T> jsonResponseHandler(Class<T> klass) {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 204) {
                return null;
            }
            String contentType = responseHeaders.getHeader(CONTENT_TYPE_HEADER);
            if (contentType != null && !contentType.startsWith(APPLICATION_JSON)) {
                NotAcceptableException notAcceptableException = new NotAcceptableException(this.buildNotAcceptableExceptionMessage(contentType, APPLICATION_JSON));
                log.error(notAcceptableException.getMessage(), (Throwable)notAcceptableException);
                throw notAcceptableException;
            }
            if (statusCode == 200 || statusCode == 201) {
                return this.jsonMapper.readValue(responseBody, klass);
            }
            ErrorResponseException errorResponseException = this.responseException(statusCode, new PushbackInputStream(responseBody), responseHeaders);
            log.error(errorResponseException.getMessage(), (Throwable)errorResponseException);
            throw errorResponseException;
        };
    }

    HttpClient.ResponseHandler<String> stringResponseHandler() {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode != 200) {
                ErrorResponseException errorResponseException = this.responseException(statusCode, new PushbackInputStream(responseBody), responseHeaders);
                log.error(errorResponseException.getMessage(), (Throwable)errorResponseException);
                throw errorResponseException;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = responseBody.read(buffer)) != -1) {
                    baos.write(buffer, 0, length);
                }
                Matcher matcher = CHARSET_PATTERN.matcher(responseHeaders.getHeader(CONTENT_TYPE_HEADER));
                String charset = StandardCharsets.UTF_8.name();
                if (matcher.find()) {
                    charset = matcher.group(1);
                }
                log.info("{} charset is used for response body parsing", (Object)charset);
                String string = baos.toString(charset);
                return string;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new UncheckedIOException(e);
            }
        };
    }

    protected ErrorResponseException responseException(int statusCode, PushbackInputStream responseBody, ResponseHeaders responseHeaders) {
        if (this.isEmpty(responseBody)) {
            return new ErrorResponseException(statusCode, responseHeaders);
        }
        return new ErrorResponseException(statusCode, responseHeaders, this.jsonMapper.readValue(responseBody, ErrorResponse.class));
    }

    private boolean isEmpty(PushbackInputStream responseBody) {
        try {
            int nextByte = responseBody.read();
            if (nextByte == -1) {
                return true;
            }
            responseBody.unread(nextByte);
            return false;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    protected static String buildUri(String uri, RequestParams requestParams) {
        if (requestParams == null) {
            return uri;
        }
        Map requestParamsMap = requestParams.toMap();
        return StringUri.withQuery(uri, requestParamsMap);
    }

    private String buildNotAcceptableExceptionMessage(String actualContentType, String expectedContentType) {
        return String.format("Content type %s is not acceptable, has to start with %s", actualContentType, expectedContentType);
    }

    protected Class<?> getSinglePaymentInitiationBodyClass() {
        return SinglePaymentInitiationBody.class;
    }
}

