/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.controller;

import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.mapper.Oauth2Mapper;
import de.adorsys.xs2a.adapter.rest.api.Oauth2Api;
import de.adorsys.xs2a.adapter.rest.api.model.TokenResponseTO;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.mapstruct.factory.Mappers;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Oauth2Controller
implements Oauth2Api {
    private final Oauth2Service oauth2Service;
    private final Oauth2Mapper mapper = (Oauth2Mapper)Mappers.getMapper(Oauth2Mapper.class);

    public Oauth2Controller(Oauth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    public HrefType getAuthorizationUrl(Map<String, String> headers, Map<String, String> parameters) throws IOException {
        URI authorizationUrl = this.oauth2Service.getAuthorizationRequestUri(headers, new Oauth2Service.Parameters(parameters));
        HrefType hrefTypeTO = new HrefType();
        hrefTypeTO.setHref(authorizationUrl.toString());
        return hrefTypeTO;
    }

    public TokenResponseTO getToken(Map<String, String> headers, Map<String, String> parameters) throws IOException {
        return this.mapper.map(this.oauth2Service.getToken(headers, new Oauth2Service.Parameters(parameters)));
    }
}

