/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.adorsys.xs2a.adapter.api.PaymentInitiationService;
import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.model.Authorisations;
import de.adorsys.xs2a.adapter.api.model.PaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.api.model.PaymentProduct;
import de.adorsys.xs2a.adapter.api.model.PaymentService;
import de.adorsys.xs2a.adapter.api.model.PeriodicPaymentInitiationMultipartBody;
import de.adorsys.xs2a.adapter.api.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.rest.api.PaymentApi;
import de.adorsys.xs2a.adapter.rest.impl.controller.AbstractController;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PaymentController
extends AbstractController
implements PaymentApi {
    private static final EnumSet<PaymentService> SUPPORTED_PAYMENT_SERVICES = EnumSet.of(PaymentService.PAYMENTS, PaymentService.PERIODIC_PAYMENTS);
    private final PaymentInitiationService paymentService;
    private final HeadersMapper headersMapper;

    public PaymentController(PaymentInitiationService paymentService, HeadersMapper headersMapper, ObjectMapper objectMapper) {
        super(objectMapper);
        this.paymentService = paymentService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> parameters, Map<String, String> headers, PeriodicPaymentInitiationMultipartBody body) {
        for (Field field : body.getClass().getDeclaredFields()) {
            parameters.remove(field.getName());
        }
        return this.initiatePaymentInternal(paymentService, paymentProduct, parameters, headers, body);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        return this.initiatePaymentInternal(paymentService, paymentProduct, parameters, headers, body);
    }

    private ResponseEntity<PaymentInitationRequestResponse201> initiatePaymentInternal(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> parameters, Map<String, String> headers, Object body) {
        this.requireSupportedPaymentService(paymentService);
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.paymentService.initiatePayment(paymentService, paymentProduct, requestHeaders, requestParams, body);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((PaymentInitationRequestResponse201)response.getBody()));
    }

    private void requireSupportedPaymentService(PaymentService paymentService) {
        if (!SUPPORTED_PAYMENT_SERVICES.contains(paymentService)) {
            throw new UnsupportedOperationException();
        }
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> parameters, Map<String, String> headers, String body) {
        return this.initiatePaymentInternal(paymentService, paymentProduct, parameters, headers, body);
    }

    public ResponseEntity<Object> getPaymentInformation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.paymentService.getPaymentInformationAsString(paymentService, paymentProduct, paymentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<ScaStatusResponse> getPaymentInitiationScaStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.paymentService.getPaymentInitiationScaStatus(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ScaStatusResponse)response.getBody()));
    }

    public ResponseEntity<Object> getPaymentInitiationStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        if (requestHeaders.isAcceptJson()) {
            Response response = this.paymentService.getPaymentInitiationStatus(paymentService, paymentProduct, paymentId, requestHeaders, requestParams);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
        }
        Response response = this.paymentService.getPaymentInitiationStatusAsString(paymentService, paymentProduct, paymentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<Authorisations> getPaymentInitiationAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.paymentService.getPaymentInitiationAuthorisation(paymentService, paymentProduct, paymentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((Authorisations)response.getBody()));
    }

    public ResponseEntity<StartScaprocessResponse> startPaymentAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.paymentService.startPaymentAuthorisation(paymentService, paymentProduct, paymentId, requestHeaders, requestParams, updatePsuAuthentication), emptyAuthorisationBody -> this.paymentService.startPaymentAuthorisation(paymentService, paymentProduct, paymentId, requestHeaders, requestParams));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((StartScaprocessResponse)response.getBody()));
    }

    public ResponseEntity<Object> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.paymentService.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication), selectPsuAuthenticationMethod -> this.paymentService.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod), transactionAuthorisation -> this.paymentService.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }
}

