/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.api.model.AccountList;
import de.adorsys.xs2a.adapter.api.model.Authorisations;
import de.adorsys.xs2a.adapter.api.model.BookingStatus;
import de.adorsys.xs2a.adapter.api.model.CardAccountList;
import de.adorsys.xs2a.adapter.api.model.CardAccountsTransactionsResponse200;
import de.adorsys.xs2a.adapter.api.model.ConsentInformationResponse200Json;
import de.adorsys.xs2a.adapter.api.model.ConsentStatusResponse200;
import de.adorsys.xs2a.adapter.api.model.Consents;
import de.adorsys.xs2a.adapter.api.model.ConsentsResponse201;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200AccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200CardAccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.ReadAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ReadCardAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.rest.api.AccountApi;
import de.adorsys.xs2a.adapter.rest.api.ConsentApi;
import de.adorsys.xs2a.adapter.rest.impl.controller.AbstractController;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConsentController
extends AbstractController
implements ConsentApi,
AccountApi {
    public static final String CONSENTS = "/v1/consents";
    private final AccountInformationService accountInformationService;
    private final HeadersMapper headersMapper;

    public ConsentController(AccountInformationService accountInformationService, ObjectMapper objectMapper, HeadersMapper headersMapper) {
        super(objectMapper);
        this.accountInformationService = accountInformationService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<ConsentsResponse201> createConsent(Map<String, String> parameters, Map<String, String> headers, Consents body) {
        Response response;
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        try {
            response = this.accountInformationService.createConsent(requestHeaders, requestParams, body);
        }
        catch (ErrorResponseException e) {
            if (e.getStatusCode() == 403 && e.getMessage() != null && e.getMessage().contains("TOKEN_INVALID")) {
                ConsentsResponse201 consentsResponse = new ConsentsResponse201();
                HrefType preOauthHref = new HrefType();
                preOauthHref.setHref("/oauth2/authorization-request-uri");
                Map<String, HrefType> preOauth = Collections.singletonMap("preOauth", preOauthHref);
                consentsResponse.setLinks(preOauth);
                return ResponseEntity.ok((Object)consentsResponse);
            }
            throw e;
        }
        ConsentsResponse201 consentsResponse = (ConsentsResponse201)response.getBody();
        if (consentsResponse.getConsentId() == null && consentsResponse.getLinks() == null) {
            HrefType oauthConsentHref = new HrefType();
            oauthConsentHref.setHref("/oauth2/authorization-request-uri");
            consentsResponse.setLinks(Collections.singletonMap("oauthConsent", oauthConsentHref));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)consentsResponse);
    }

    public ResponseEntity<ConsentInformationResponse200Json> getConsentInformation(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestParams requestParams = RequestParams.fromMap(parameters);
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.accountInformationService.getConsentInformation(consentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ConsentInformationResponse200Json)response.getBody()));
    }

    public ResponseEntity<Void> deleteConsent(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.deleteConsent(consentId, requestHeaders, requestParams);
        return new ResponseEntity((MultiValueMap)this.headersMapper.toHttpHeaders(response.getHeaders()), HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<ConsentStatusResponse200> getConsentStatus(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getConsentStatus(consentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ConsentStatusResponse200)response.getBody()));
    }

    public ResponseEntity<Authorisations> getConsentAuthorisation(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getConsentAuthorisation(consentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((Authorisations)response.getBody()));
    }

    public ResponseEntity<StartScaprocessResponse> startConsentAuthorisation(String consentId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.accountInformationService.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication), emptyAuthorisationBody -> this.accountInformationService.startConsentAuthorisation(consentId, requestHeaders, requestParams));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((StartScaprocessResponse)response.getBody()));
    }

    public ResponseEntity<Object> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication), selectPsuAuthenticationMethod -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod), transactionAuthorisation -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<AccountList> getAccountList(Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.builder().withBalance(withBalance).build();
        Response response = this.accountInformationService.getAccountList(requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((AccountList)response.getBody()));
    }

    public ResponseEntity<OK200AccountDetails> readAccountDetails(String accountId, Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.builder().withBalance(withBalance).build();
        Response response = this.accountInformationService.readAccountDetails(accountId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((OK200AccountDetails)response.getBody()));
    }

    public ResponseEntity<Object> getTransactionList(String accountId, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, BookingStatus bookingStatus, Boolean deltaList, Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        if (requestHeaders.isAcceptJson()) {
            Response transactionList = this.accountInformationService.getTransactionList(accountId, requestHeaders, requestParams);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(transactionList.getHeaders()))).body(transactionList.getBody());
        }
        Response response = this.accountInformationService.getTransactionListAsString(accountId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<OK200TransactionDetails> getTransactionDetails(String accountId, String transactionId, Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getTransactionDetails(accountId, transactionId, RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((OK200TransactionDetails)response.getBody()));
    }

    public ResponseEntity<CardAccountList> getCardAccount(Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getCardAccountList(RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((CardAccountList)response.getBody()));
    }

    public ResponseEntity<OK200CardAccountDetails> ReadCardAccount(String accountId, Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getCardAccountDetails(accountId, RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((OK200CardAccountDetails)response.getBody()));
    }

    public ResponseEntity<ReadCardAccountBalanceResponse200> getCardAccountBalances(String accountId, Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getCardAccountBalances(accountId, RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ReadCardAccountBalanceResponse200)response.getBody()));
    }

    public ResponseEntity<CardAccountsTransactionsResponse200> getCardAccountTransactionList(String accountId, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, BookingStatus bookingStatus, Boolean deltaList, Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getCardAccountTransactionList(accountId, RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((CardAccountsTransactionsResponse200)response.getBody()));
    }

    public ResponseEntity<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getConsentScaStatus(consentId, authorisationId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ScaStatusResponse)response.getBody()));
    }

    public ResponseEntity<ReadAccountBalanceResponse200> getBalances(String accountId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getBalances(accountId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)((ReadAccountBalanceResponse200)response.getBody()));
    }
}

