/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.exception.BadRequestException;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.api.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthentication;

public abstract class AbstractController {
    private final ObjectMapper objectMapper;

    protected AbstractController(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    Response handleAuthorisationBody(ObjectNode body, AuthorisationBodyHandler ... handlers) {
        for (AuthorisationBodyHandler handler : handlers) {
            if (!handler.isApplicable(body)) continue;
            return handler.apply(body, this.objectMapper);
        }
        throw new BadRequestException("Request body doesn't match any of the supported schemas");
    }

    @FunctionalInterface
    static interface StartAuthorisationHandler
    extends AuthorisationBodyHandler<EmptyAuthorisationBody> {
        @Override
        default public boolean isApplicable(ObjectNode body) {
            return !body.fields().hasNext();
        }

        @Override
        default public Response apply(ObjectNode body, ObjectMapper objectMapper) {
            return this.apply(new EmptyAuthorisationBody());
        }

        public static class EmptyAuthorisationBody {
        }
    }

    @FunctionalInterface
    static interface TransactionAuthorisationHandler
    extends AuthorisationBodyHandler<TransactionAuthorisation> {
        @Override
        default public boolean isApplicable(ObjectNode body) {
            return body.has("scaAuthenticationData");
        }

        @Override
        default public Response apply(ObjectNode body, ObjectMapper objectMapper) {
            return this.apply((TransactionAuthorisation)objectMapper.convertValue((Object)body, TransactionAuthorisation.class));
        }
    }

    @FunctionalInterface
    static interface SelectPsuAuthenticationMethodHandler
    extends AuthorisationBodyHandler<SelectPsuAuthenticationMethod> {
        @Override
        default public boolean isApplicable(ObjectNode body) {
            return body.has("authenticationMethodId");
        }

        @Override
        default public Response apply(ObjectNode body, ObjectMapper objectMapper) {
            return this.apply((SelectPsuAuthenticationMethod)objectMapper.convertValue((Object)body, SelectPsuAuthenticationMethod.class));
        }
    }

    @FunctionalInterface
    static interface UpdatePsuAuthenticationHandler
    extends AuthorisationBodyHandler<UpdatePsuAuthentication> {
        @Override
        default public boolean isApplicable(ObjectNode body) {
            return body.has("psuData");
        }

        @Override
        default public Response apply(ObjectNode body, ObjectMapper objectMapper) {
            return this.apply((UpdatePsuAuthentication)objectMapper.convertValue((Object)body, UpdatePsuAuthentication.class));
        }
    }

    static interface AuthorisationBodyHandler<T> {
        public boolean isApplicable(ObjectNode var1);

        public Response apply(ObjectNode var1, ObjectMapper var2);

        public Response apply(T var1);
    }
}

