/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.config;

import de.adorsys.xs2a.adapter.api.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.api.exception.AspspRegistrationException;
import de.adorsys.xs2a.adapter.api.exception.AspspRegistrationNotFoundException;
import de.adorsys.xs2a.adapter.api.exception.BadRequestException;
import de.adorsys.xs2a.adapter.api.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.api.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.api.exception.IbanException;
import de.adorsys.xs2a.adapter.api.exception.NotAcceptableException;
import de.adorsys.xs2a.adapter.api.exception.OAuthException;
import de.adorsys.xs2a.adapter.api.exception.PreAuthorisationException;
import de.adorsys.xs2a.adapter.api.exception.PsuPasswordEncodingException;
import de.adorsys.xs2a.adapter.api.exception.UncheckedSSLHandshakeException;
import de.adorsys.xs2a.adapter.api.model.ErrorResponse;
import de.adorsys.xs2a.adapter.api.model.MessageCode;
import de.adorsys.xs2a.adapter.api.model.TppMessage;
import de.adorsys.xs2a.adapter.api.model.TppMessageCategory;
import de.adorsys.xs2a.adapter.api.validation.RequestValidationException;
import de.adorsys.xs2a.adapter.api.validation.ValidationError;
import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.MDC;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String ERROR_ORIGINATION_HEADER_NAME = "X-GTW-Error-Origination";
    private final HeadersMapper headersMapper;

    public RestExceptionHandler(HeadersMapper headersMapper) {
        this.headersMapper = headersMapper;
    }

    @ExceptionHandler
    ResponseEntity handle(ErrorResponseException exception) {
        this.logError((Exception)exception);
        HttpHeaders responseHeaders = this.addErrorOriginationHeader(this.headersMapper.toHttpHeaders(exception.getResponseHeaders()), ErrorOrigination.BANK);
        HttpStatus status = HttpStatus.valueOf((int)exception.getStatusCode());
        return exception.getErrorResponse().map(response -> {
            String originalResponse = exception.getMessage();
            if (response.getTppMessages() == null && response.getLinks() == null && originalResponse != null && !originalResponse.isEmpty()) {
                return new ResponseEntity((Object)originalResponse, (MultiValueMap)responseHeaders, status);
            }
            return new ResponseEntity(response, (MultiValueMap)responseHeaders, status);
        }).orElseGet(() -> new ResponseEntity((MultiValueMap)responseHeaders, status));
    }

    @ExceptionHandler
    ResponseEntity<Object> handle(PreAuthorisationException exception) {
        this.logError((Exception)exception);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)exception.getErrorResponse(), (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler
    ResponseEntity<Object> handle(OAuthException exception) {
        this.logError((Exception)exception);
        HttpHeaders responseHeaders = this.addErrorOriginationHeader(this.headersMapper.toHttpHeaders(exception.getResponseHeaders()), ErrorOrigination.BANK);
        String originalResponse = exception.getMessage();
        ErrorResponse errorResponse = exception.getErrorResponse();
        ResponseEntity.BodyBuilder responseBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).headers(responseHeaders);
        if (errorResponse != null && (errorResponse.getTppMessages() != null || errorResponse.getLinks() != null)) {
            return responseBuilder.body((Object)errorResponse);
        }
        if (originalResponse != null && !originalResponse.trim().isEmpty()) {
            return responseBuilder.body((Object)originalResponse);
        }
        return responseBuilder.build();
    }

    @ExceptionHandler
    ResponseEntity<Object> handle(NotAcceptableException exception) {
        this.logError((Exception)exception);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).headers(this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.BANK))).build();
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(HttpRequestSigningException exception) {
        this.logError((Exception)exception);
        ErrorResponse errorResponse = this.buildErrorResponse("Exception during the request signing process");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(UncheckedSSLHandshakeException exception) {
        this.logError((Exception)exception);
        ErrorResponse errorResponse = this.buildErrorResponse("Exception during the SSL handshake process");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.BANK);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(UncheckedIOException exception) {
        this.logError(exception);
        ErrorResponse errorResponse = this.buildErrorResponse("Exception during the IO process");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(UnsupportedOperationException exception) {
        this.logError(exception);
        ErrorResponse errorResponse = this.buildErrorResponse("This endpoint is not supported yet");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.NOT_IMPLEMENTED);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(RequestValidationException exception) {
        this.logError((Exception)exception);
        ErrorResponse errorResponse = new ErrorResponse();
        ArrayList<TppMessage> tppMessages = new ArrayList<TppMessage>();
        for (ValidationError validationError : exception.getValidationErrors()) {
            TppMessage tppMessage = new TppMessage();
            tppMessage.setCategory(TppMessageCategory.ERROR);
            tppMessage.setCode(MessageCode.FORMAT_ERROR);
            tppMessage.setPath(validationError.getPath());
            tppMessage.setText(validationError.getMessage());
            tppMessages.add(tppMessage);
        }
        errorResponse.setTppMessages(tppMessages);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BadRequestException.class, AspspRegistrationException.class, AspspRegistrationNotFoundException.class, AdapterNotFoundException.class, IbanException.class})
    ResponseEntity<Object> handleAsBadRequest(Exception exception) {
        this.logError(exception);
        return this.handleAsBadRequest(exception.getMessage());
    }

    private ResponseEntity<Object> handleAsBadRequest(String errorText) {
        ErrorResponse errorResponse = this.buildErrorResponse(errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logError((Exception)ex);
        return this.handleAsBadRequest("Required parameter '" + ex.getParameterName() + "' is missing");
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (ex instanceof MethodArgumentTypeMismatchException) {
            this.logError((Exception)ex);
            MethodArgumentTypeMismatchException exception = (MethodArgumentTypeMismatchException)ex;
            String errorMessage = "Illegal value '" + exception.getValue() + "' for parameter '" + exception.getName() + "'";
            Class parameterType = exception.getParameter().getParameterType();
            if (parameterType.isEnum()) {
                errorMessage = errorMessage + ", allowed values: " + Arrays.stream(parameterType.getEnumConstants()).map(Objects::toString).collect(Collectors.joining(", "));
            }
            return this.handleAsBadRequest(errorMessage);
        }
        return super.handleTypeMismatch(ex, headers, status, request);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(PsuPasswordEncodingException exception) {
        this.logError((Exception)exception);
        ErrorResponse errorResponse = this.buildErrorResponse("Exception during PSU password encryption");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler
    ResponseEntity<ErrorResponse> handle(Exception exception) {
        this.logError(exception);
        ErrorResponse errorResponse = this.buildErrorResponse("Server error");
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ErrorResponse buildErrorResponse(String text) {
        TppMessage tppMessage = new TppMessage();
        tppMessage.setCategory(TppMessageCategory.ERROR);
        tppMessage.setText(text);
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setTppMessages(Collections.singletonList(tppMessage));
        return errorResponse;
    }

    private HttpHeaders addErrorOriginationHeader(HttpHeaders httpHeaders, ErrorOrigination errorOrigination) {
        httpHeaders.add(ERROR_ORIGINATION_HEADER_NAME, errorOrigination.name());
        return httpHeaders;
    }

    private void logError(Exception exception) {
        String errorMessage = exception.getMessage() == null ? "" : exception.getMessage();
        this.logger.error((Object)errorMessage, (Throwable)exception);
        MDC.put((String)"errorMessage", (String)errorMessage);
    }

    private static enum ErrorOrigination {
        BANK,
        ADAPTER;

    }
}

