/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.adorsys.xs2a.adapter.api.model.BookingStatus;
import de.adorsys.xs2a.adapter.api.model.PaymentProduct;
import de.adorsys.xs2a.adapter.api.model.PaymentService;
import de.adorsys.xs2a.adapter.api.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.xs2a.adapter.rest.impl.config.PeriodicPaymentInitiationMultipartBodyHttpMessageConverter;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final String SWAGGER_URL = "/swagger-ui.html";
    private final ObjectMapper objectMapper = WebMvcConfig.newConfiguredObjectMapper();

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("", SWAGGER_URL);
    }

    public void addFormatters(FormatterRegistry registry) {
        DateTimeFormatterRegistrar registrar = new DateTimeFormatterRegistrar();
        registrar.setUseIsoFormat(true);
        registrar.registerFormatters(registry);
        registry.addConverter((Converter)new Converter<String, BookingStatus>(){

            public BookingStatus convert(String source) {
                return BookingStatus.fromValue((String)source);
            }
        });
        registry.addConverter((Converter)new Converter<BookingStatus, String>(){

            public String convert(BookingStatus source) {
                return source.toString();
            }
        });
        registry.addConverter((Converter)new Converter<String, PaymentService>(){

            public PaymentService convert(String source) {
                return PaymentService.fromValue((String)source);
            }
        });
        registry.addConverter((Converter)new Converter<PaymentProduct, String>(){

            public String convert(PaymentProduct source) {
                return source.toString();
            }
        });
        registry.addConverter((Converter)new Converter<PaymentService, String>(){

            public String convert(PaymentService source) {
                return source.toString();
            }
        });
        registry.addConverter((Converter)new Converter<String, PaymentProduct>(){

            public PaymentProduct convert(String source) {
                return PaymentProduct.fromValue((String)source);
            }
        });
        registry.addConverter((Converter)new Converter<String, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson>(){

            public PeriodicPaymentInitiationXmlPart2StandingorderTypeJson convert(String source) {
                try {
                    return (PeriodicPaymentInitiationXmlPart2StandingorderTypeJson)WebMvcConfig.this.objectMapper.readValue(source, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson.class);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, new PeriodicPaymentInitiationMultipartBodyHttpMessageConverter(this.objectMapper));
    }

    @Bean
    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public static ObjectMapper newConfiguredObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper;
    }
}

