/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.rest.impl.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.util.mime.MimeUtility;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="xs2a-adapter.rest", name={"mime-headers-support-enabled"}, havingValue="true", matchIfMissing=true)
@Component
public class MimeHeadersSupportFilter
extends HttpFilter {
    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        MimeHeaderRequestWrapper request = new MimeHeaderRequestWrapper(req);
        chain.doFilter((ServletRequest)request, (ServletResponse)res);
    }

    private static class MimeHeaderRequestWrapper
    extends HttpServletRequestWrapper {
        MimeHeaderRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            String header = super.getHeader(name);
            return this.decodeHeader(header);
        }

        private String decodeHeader(String header) {
            if (header == null) {
                return null;
            }
            try {
                return MimeUtility.decodeText((String)header);
            }
            catch (UnsupportedEncodingException e) {
                return header;
            }
        }

        public Enumeration<String> getHeaders(String name) {
            Enumeration headers = super.getHeaders(name);
            ArrayList<String> decodedHeaders = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                String s = (String)headers.nextElement();
                decodedHeaders.add(this.decodeHeader(s));
            }
            return Collections.enumeration(decodedHeaders);
        }
    }
}

