/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.adorsys.xs2a.adapter.api.AccountApi;
import de.adorsys.xs2a.adapter.api.ConsentApi;
import de.adorsys.xs2a.adapter.controller.AbstractController;
import de.adorsys.xs2a.adapter.mapper.AccountListHolderMapper;
import de.adorsys.xs2a.adapter.mapper.BalanceReportMapper;
import de.adorsys.xs2a.adapter.mapper.ConsentCreationResponseMapper;
import de.adorsys.xs2a.adapter.mapper.ConsentInformationMapper;
import de.adorsys.xs2a.adapter.mapper.ConsentMapper;
import de.adorsys.xs2a.adapter.mapper.ConsentStatusResponseMapper;
import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.mapper.ScaStatusResponseMapper;
import de.adorsys.xs2a.adapter.mapper.TransactionDetailsMapper;
import de.adorsys.xs2a.adapter.mapper.TransactionsReportMapper;
import de.adorsys.xs2a.adapter.model.AccountListTO;
import de.adorsys.xs2a.adapter.model.BookingStatusTO;
import de.adorsys.xs2a.adapter.model.ConsentInformationResponse200JsonTO;
import de.adorsys.xs2a.adapter.model.ConsentStatusResponse200TO;
import de.adorsys.xs2a.adapter.model.ConsentsResponse201TO;
import de.adorsys.xs2a.adapter.model.ConsentsTO;
import de.adorsys.xs2a.adapter.model.OK200TransactionDetailsTO;
import de.adorsys.xs2a.adapter.model.ReadAccountBalanceResponse200TO;
import de.adorsys.xs2a.adapter.model.ScaStatusResponseTO;
import de.adorsys.xs2a.adapter.model.StartScaprocessResponseTO;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import java.time.LocalDate;
import java.util.Map;
import org.mapstruct.factory.Mappers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConsentController
extends AbstractController
implements ConsentApi,
AccountApi {
    public static final String CONSENTS = "/v1/consents";
    private final AccountInformationService accountInformationService;
    private final HeadersMapper headersMapper;
    private final ConsentMapper consentMapper = (ConsentMapper)Mappers.getMapper(ConsentMapper.class);
    private final ConsentCreationResponseMapper creationResponseMapper = (ConsentCreationResponseMapper)Mappers.getMapper(ConsentCreationResponseMapper.class);
    private final ConsentInformationMapper consentInformationMapper = (ConsentInformationMapper)Mappers.getMapper(ConsentInformationMapper.class);
    private final ConsentStatusResponseMapper consentStatusResponseMapper = (ConsentStatusResponseMapper)Mappers.getMapper(ConsentStatusResponseMapper.class);
    private final AccountListHolderMapper accountListHolderMapper = (AccountListHolderMapper)Mappers.getMapper(AccountListHolderMapper.class);
    private final ScaStatusResponseMapper scaStatusResponseMapper = (ScaStatusResponseMapper)Mappers.getMapper(ScaStatusResponseMapper.class);
    private final BalanceReportMapper balanceReportMapper = (BalanceReportMapper)Mappers.getMapper(BalanceReportMapper.class);
    private final TransactionsReportMapper transactionsReportMapper = (TransactionsReportMapper)Mappers.getMapper(TransactionsReportMapper.class);
    private final TransactionDetailsMapper transactionDetailsMapper = (TransactionDetailsMapper)Mappers.getMapper(TransactionDetailsMapper.class);

    public ConsentController(AccountInformationService accountInformationService, ObjectMapper objectMapper, HeadersMapper headersMapper) {
        super(objectMapper);
        this.accountInformationService = accountInformationService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<ConsentsResponse201TO> createConsent(Map<String, String> parameters, Map<String, String> headers, ConsentsTO body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Consents consents = this.consentMapper.toConsents(body);
        Response response = this.accountInformationService.createConsent(requestHeaders, requestParams, consents);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.creationResponseMapper.toConsentResponse201((ConsentCreationResponse)response.getBody()));
    }

    public ResponseEntity<ConsentInformationResponse200JsonTO> getConsentInformation(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestParams requestParams = RequestParams.fromMap(parameters);
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.accountInformationService.getConsentInformation(consentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.consentInformationMapper.toConsentInformationResponse200Json((ConsentInformation)response.getBody()));
    }

    public ResponseEntity<Void> deleteConsent(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.deleteConsent(consentId, requestHeaders, requestParams);
        return new ResponseEntity((MultiValueMap)this.headersMapper.toHttpHeaders(response.getHeaders()), HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<ConsentStatusResponse200TO> getConsentStatus(String consentId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getConsentStatus(consentId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.consentStatusResponseMapper.toConsentStatusResponse200((ConsentStatusResponse)response.getBody()));
    }

    public ResponseEntity<StartScaprocessResponseTO> startConsentAuthorisation(String consentId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.accountInformationService.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication), emptyAuthorisationBody -> this.accountInformationService.startConsentAuthorisation(consentId, requestHeaders, requestParams));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.startScaProcessResponseMapper.toStartScaprocessResponseTO((StartScaProcessResponse)response.getBody()));
    }

    public ResponseEntity<Object> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication), selectPsuAuthenticationMethod -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod), transactionAuthorisation -> this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<AccountListTO> getAccountList(Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.builder().withBalance(withBalance).build();
        Response response = this.accountInformationService.getAccountList(requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.accountListHolderMapper.toAccountListTO((AccountListHolder)response.getBody()));
    }

    public ResponseEntity<Object> getTransactionList(String accountId, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, BookingStatusTO bookingStatus, Boolean deltaList, Boolean withBalance, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.builder().bookingStatus(bookingStatus.toString()).dateFrom(dateFrom).dateTo(dateTo).entryReferenceFrom(entryReferenceFrom).deltaList(deltaList).withBalance(withBalance).build();
        if (requestHeaders.isAcceptJson()) {
            Response transactionList = this.accountInformationService.getTransactionList(accountId, requestHeaders, requestParams);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(transactionList.getHeaders()))).body((Object)this.transactionsReportMapper.toTransactionsResponse200Json((TransactionsReport)transactionList.getBody()));
        }
        Response response = this.accountInformationService.getTransactionListAsString(accountId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<OK200TransactionDetailsTO> getTransactionDetails(String accountId, String transactionId, Map<String, String> parameters, Map<String, String> headers) {
        Response response = this.accountInformationService.getTransactionDetails(accountId, transactionId, RequestHeaders.fromMap(headers), RequestParams.fromMap(parameters));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.transactionDetailsMapper.map((TransactionDetails)response.getBody()));
    }

    public ResponseEntity<ScaStatusResponseTO> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getConsentScaStatus(consentId, authorisationId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.scaStatusResponseMapper.toScaStatusResponseTO((ScaStatusResponse)response.getBody()));
    }

    public ResponseEntity<ReadAccountBalanceResponse200TO> getBalances(String accountId, Map<String, String> parameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(parameters);
        Response response = this.accountInformationService.getBalances(accountId, requestHeaders, requestParams);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.balanceReportMapper.toReadAccountBalanceResponse200TO((BalanceReport)response.getBody()));
    }
}

