/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.mapper.psd2.Psd2AccountInformationMapper;
import de.adorsys.xs2a.adapter.rest.psd2.Psd2AccountInformationApi;
import de.adorsys.xs2a.adapter.rest.psd2.model.AccountListTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentInformationResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentStatusResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentsResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentsTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ReadAccountBalanceResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ScaStatusResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.StartScaProcessResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationTO;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import de.adorsys.xs2a.adapter.service.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
public class Psd2AccountInformationController
implements Psd2AccountInformationApi {
    private final Psd2AccountInformationService accountInformationService;
    private final HeadersMapper headersMapper;
    private final Psd2AccountInformationMapper mapper = (Psd2AccountInformationMapper)Mappers.getMapper(Psd2AccountInformationMapper.class);

    public Psd2AccountInformationController(Psd2AccountInformationService accountInformationService, HeadersMapper headersMapper) {
        this.accountInformationService = accountInformationService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<ConsentsResponseTO> createConsent(Map<String, String> headers, ConsentsTO body) {
        try {
            return this.createConsent0(headers, body);
        }
        catch (ErrorResponseException ex) {
            if (ex.getStatusCode() == 403 && ex.getMessage() != null && ex.getMessage().contains("TOKEN_INVALID")) {
                ConsentsResponse consentsResponse = new ConsentsResponse();
                consentsResponse.setLinks(Collections.singletonMap("preOauth", new HrefType("/oauth2/authorization-request-uri")));
                return this.toResponseEntity(new Response(200, (Object)consentsResponse, ResponseHeaders.emptyResponseHeaders()), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toConsentsResponseTO(arg_0));
            }
            throw ex;
        }
    }

    private ResponseEntity<ConsentsResponseTO> createConsent0(Map<String, String> headers, ConsentsTO body) {
        Response response = this.accountInformationService.createConsent(headers, this.mapper.toConsents(body));
        ConsentsResponse consentsResponse = (ConsentsResponse)response.getBody();
        if (consentsResponse.getConsentId() == null && consentsResponse.getLinks() == null) {
            consentsResponse.setLinks(Collections.singletonMap("oauthConsent", new HrefType("/oauth2/authorization-request-uri")));
        }
        return this.toResponseEntity(response, arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toConsentsResponseTO(arg_0));
    }

    private <T, U> ResponseEntity<U> toResponseEntity(Response<T> response, Function<? super T, ? extends U> bodyMapper) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(bodyMapper.apply(response.getBody()));
    }

    public ResponseEntity<ConsentInformationResponseTO> getConsentInformation(String consentId, Map<String, String> headers) {
        return this.toResponseEntity(this.accountInformationService.getConsentInformation(consentId, headers), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toConsentInformationResponseTO(arg_0));
    }

    public ResponseEntity<Void> deleteConsent(String consentId, Map<String, String> headers) {
        Response response = this.accountInformationService.deleteConsent(consentId, headers);
        return ResponseEntity.noContent().headers(this.headersMapper.toHttpHeaders(response.getHeaders())).build();
    }

    public ResponseEntity<ConsentStatusResponseTO> getConsentStatus(String consentId, Map<String, String> headers) {
        return this.toResponseEntity(this.accountInformationService.getConsentStatus(consentId, headers), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toConsentStatusResponseTO(arg_0));
    }

    public ResponseEntity<StartScaProcessResponseTO> startConsentAuthorisation(String consentId, Map<String, String> headers, UpdateAuthorisationTO body) {
        return this.toResponseEntity(this.accountInformationService.startConsentAuthorisation(consentId, headers, this.mapper.toUpdateAuthorisation(body)), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toStartScaProcessResponseTO(arg_0));
    }

    public ResponseEntity<ScaStatusResponseTO> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> headers) {
        return this.toResponseEntity(this.accountInformationService.getConsentScaStatus(consentId, authorisationId, headers), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toScaStatusResponseTO(arg_0));
    }

    public ResponseEntity<UpdateAuthorisationResponseTO> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> headers, UpdateAuthorisationTO body) {
        return this.toResponseEntity(this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, headers, this.mapper.toUpdateAuthorisation(body)), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toUpdateAuthorisationResponseTO(arg_0));
    }

    public ResponseEntity<AccountListTO> getAccountList(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getAccounts(queryParameters, headers), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toAccountListTO(arg_0));
    }

    public ResponseEntity<ReadAccountBalanceResponseTO> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getBalances(accountId, queryParameters, headers), arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toReadAccountBalanceResponseTO(arg_0));
    }

    public ResponseEntity getTransactionList(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.accountInformationService.getTransactions(accountId, queryParameters, headers);
        if (response.getBody() instanceof TransactionsResponse) {
            return this.toResponseEntity(response, arg_0 -> ((Psd2AccountInformationMapper)this.mapper).toTransactionsResponseTO(arg_0));
        }
        return this.toResponseEntity(response, Function.identity());
    }
}

