/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.adorsys.xs2a.adapter.api.PaymentApi;
import de.adorsys.xs2a.adapter.controller.AbstractController;
import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.mapper.PaymentInitiationAuthorisationResponseMapper;
import de.adorsys.xs2a.adapter.mapper.PaymentInitiationRequestResponseMapper;
import de.adorsys.xs2a.adapter.mapper.PaymentInitiationScaStatusResponseMapper;
import de.adorsys.xs2a.adapter.mapper.PaymentInitiationStatusMapper;
import de.adorsys.xs2a.adapter.mapper.SinglePaymentInformationMapper;
import de.adorsys.xs2a.adapter.model.AuthorisationsTO;
import de.adorsys.xs2a.adapter.model.PaymentInitationRequestResponse201TO;
import de.adorsys.xs2a.adapter.model.PaymentProductTO;
import de.adorsys.xs2a.adapter.model.PaymentServiceTO;
import de.adorsys.xs2a.adapter.model.ScaStatusResponseTO;
import de.adorsys.xs2a.adapter.model.StartScaprocessResponseTO;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationAuthorisationResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationStatus;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationInformationWithStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import java.util.Map;
import org.mapstruct.factory.Mappers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PaymentController
extends AbstractController
implements PaymentApi {
    private final PaymentInitiationService paymentService;
    private final PaymentInitiationScaStatusResponseMapper paymentInitiationScaStatusResponseMapper;
    private final HeadersMapper headersMapper;
    private final PaymentInitiationRequestResponseMapper paymentInitiationRequestResponseMapper = (PaymentInitiationRequestResponseMapper)Mappers.getMapper(PaymentInitiationRequestResponseMapper.class);
    private final SinglePaymentInformationMapper singlePaymentInformationMapper = (SinglePaymentInformationMapper)Mappers.getMapper(SinglePaymentInformationMapper.class);
    private final PaymentInitiationStatusMapper paymentInitiationStatusMapper = (PaymentInitiationStatusMapper)Mappers.getMapper(PaymentInitiationStatusMapper.class);
    private final PaymentInitiationAuthorisationResponseMapper paymentInitiationAuthorisationResponseMapper = (PaymentInitiationAuthorisationResponseMapper)Mappers.getMapper(PaymentInitiationAuthorisationResponseMapper.class);

    public PaymentController(PaymentInitiationService paymentService, PaymentInitiationScaStatusResponseMapper paymentInitiationScaStatusResponseMapper, HeadersMapper headersMapper, ObjectMapper objectMapper) {
        super(objectMapper);
        this.paymentService = paymentService;
        this.paymentInitiationScaStatusResponseMapper = paymentInitiationScaStatusResponseMapper;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<PaymentInitationRequestResponse201TO> initiatePayment(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, Map<String, String> headers, ObjectNode body) {
        return this.initiatePaymentInternal(paymentService, paymentProduct, headers, body);
    }

    private ResponseEntity<PaymentInitationRequestResponse201TO> initiatePaymentInternal(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, Map<String, String> headers, Object body) {
        this.requireSinglePayment(paymentService);
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.paymentService.initiateSinglePayment(paymentProduct.toString(), requestHeaders, body);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.paymentInitiationRequestResponseMapper.toPaymentInitationRequestResponse201TO((PaymentInitiationRequestResponse)response.getBody()));
    }

    private void requireSinglePayment(PaymentServiceTO paymentService) {
        if (paymentService != PaymentServiceTO.PAYMENTS) {
            throw new UnsupportedOperationException();
        }
    }

    public ResponseEntity<PaymentInitationRequestResponse201TO> initiatePayment(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, Map<String, String> headers, String body) {
        return this.initiatePaymentInternal(paymentService, paymentProduct, headers, body);
    }

    public ResponseEntity<Object> getPaymentInformation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.paymentService.getSinglePaymentInformation(paymentProduct.toString(), paymentId, requestHeaders);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.singlePaymentInformationMapper.toPaymentInitiationSctWithStatusResponse((SinglePaymentInitiationInformationWithStatusResponse)response.getBody()));
    }

    public ResponseEntity<ScaStatusResponseTO> getPaymentInitiationScaStatus(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, String authorisationId, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.paymentService.getPaymentInitiationScaStatus(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, requestHeaders);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.paymentInitiationScaStatusResponseMapper.mapToScaStatusResponse((PaymentInitiationScaStatusResponse)response.getBody()));
    }

    public ResponseEntity<Object> getPaymentInitiationStatus(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        if (requestHeaders.isAcceptJson()) {
            Response response = this.paymentService.getSinglePaymentInitiationStatus(paymentProduct.toString(), paymentId, requestHeaders);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.paymentInitiationStatusMapper.toPaymentInitiationStatusResponse200Json((PaymentInitiationStatus)response.getBody()));
        }
        Response response = this.paymentService.getSinglePaymentInitiationStatusAsString(paymentProduct.toString(), paymentId, requestHeaders);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }

    public ResponseEntity<AuthorisationsTO> getPaymentInitiationAuthorisation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.paymentService.getPaymentInitiationAuthorisation(paymentService.toString(), paymentProduct.toString(), paymentId, requestHeaders);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.paymentInitiationAuthorisationResponseMapper.toAuthorisationsTO((PaymentInitiationAuthorisationResponse)response.getBody()));
    }

    public ResponseEntity<StartScaprocessResponseTO> startPaymentAuthorisation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.paymentService.startSinglePaymentAuthorisation(paymentProduct.toString(), paymentId, requestHeaders, updatePsuAuthentication));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body((Object)this.startScaProcessResponseMapper.toStartScaprocessResponseTO((StartScaProcessResponse)response.getBody()));
    }

    public ResponseEntity<Object> updatePaymentPsuData(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, String authorisationId, Map<String, String> headers, ObjectNode body) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        Response response = this.handleAuthorisationBody(body, updatePsuAuthentication -> this.paymentService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, requestHeaders, updatePsuAuthentication), selectPsuAuthenticationMethod -> this.paymentService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, requestHeaders, selectPsuAuthenticationMethod), transactionAuthorisation -> this.paymentService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, requestHeaders, transactionAuthorisation));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(response.getBody());
    }
}

