/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import de.adorsys.xs2a.adapter.api.AspspSearchApi;
import de.adorsys.xs2a.adapter.mapper.AspspMapper;
import de.adorsys.xs2a.adapter.model.AspspTO;
import de.adorsys.xs2a.adapter.service.AspspReadOnlyRepository;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import java.util.List;
import java.util.Optional;
import org.mapstruct.factory.Mappers;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AspspSearchController
implements AspspSearchApi {
    private final AspspReadOnlyRepository aspspSearchService;
    private final AspspMapper aspspMapper = (AspspMapper)Mappers.getMapper(AspspMapper.class);

    public AspspSearchController(AspspReadOnlyRepository aspspSearchService) {
        this.aspspSearchService = aspspSearchService;
    }

    public ResponseEntity<List<AspspTO>> getAspsps(@RequestParam(required=false) String name, @RequestParam(required=false) String bic, @RequestParam(required=false) String bankCode, @RequestParam(required=false) String iban, @RequestParam(required=false) String after, @RequestParam(required=false, defaultValue="10") int size) {
        List aspsps;
        if (iban != null) {
            aspsps = this.aspspSearchService.findByIban(iban, after, size);
        } else if (name == null && bic == null && bankCode == null) {
            aspsps = this.aspspSearchService.findAll(after, size);
        } else {
            Aspsp aspsp = new Aspsp();
            aspsp.setName(name);
            aspsp.setBic(bic);
            aspsp.setBankCode(bankCode);
            aspsps = this.aspspSearchService.findLike(aspsp, after, size);
        }
        return ResponseEntity.ok((Object)this.aspspMapper.toAspspTOs((Iterable)aspsps));
    }

    public ResponseEntity<AspspTO> getById(String id) {
        Optional aspsp = this.aspspSearchService.findById(id);
        return aspsp.map(value -> ResponseEntity.ok((Object)this.aspspMapper.toAspspTO(value))).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

