/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.config;

import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.model.TppMessageCategoryTO;
import de.adorsys.xs2a.adapter.service.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.service.exception.AspspRegistrationException;
import de.adorsys.xs2a.adapter.service.exception.AspspRegistrationNotFoundException;
import de.adorsys.xs2a.adapter.service.exception.BadRequestException;
import de.adorsys.xs2a.adapter.service.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.service.exception.IbanException;
import de.adorsys.xs2a.adapter.service.exception.NotAcceptableException;
import de.adorsys.xs2a.adapter.service.exception.OAuthException;
import de.adorsys.xs2a.adapter.service.exception.PsuPasswordEncodingException;
import de.adorsys.xs2a.adapter.service.exception.UncheckedSSLHandshakeException;
import de.adorsys.xs2a.adapter.service.model.ErrorResponse;
import de.adorsys.xs2a.adapter.service.model.TppMessage;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.MDC;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String ERROR_ORIGINATION_HEADER_NAME = "X-GTW-Error-Origination";
    private final HeadersMapper headersMapper;

    public RestExceptionHandler(HeadersMapper headersMapper) {
        this.headersMapper = headersMapper;
    }

    @ExceptionHandler
    ResponseEntity handle(ErrorResponseException exception) {
        this.logError((Exception)exception);
        HttpHeaders responseHeaders = this.addErrorOriginationHeader(this.headersMapper.toHttpHeaders(exception.getResponseHeaders()), ErrorOrigination.BANK);
        HttpStatus status = HttpStatus.valueOf((int)exception.getStatusCode());
        return exception.getErrorResponse().map(response -> {
            String originalResponse = exception.getMessage();
            if (response.isEmpty() && originalResponse != null && !originalResponse.isEmpty()) {
                return new ResponseEntity((Object)originalResponse, (MultiValueMap)responseHeaders, status);
            }
            return new ResponseEntity(response, (MultiValueMap)responseHeaders, status);
        }).orElseGet(() -> new ResponseEntity((MultiValueMap)responseHeaders, status));
    }

    @ExceptionHandler
    ResponseEntity handle(OAuthException exception) {
        this.logError((Exception)exception);
        HttpHeaders responseHeaders = this.addErrorOriginationHeader(this.headersMapper.toHttpHeaders(exception.getResponseHeaders()), ErrorOrigination.BANK);
        String originalResponse = exception.getMessage();
        ErrorResponse errorResponse = exception.getErrorResponse();
        ResponseEntity.BodyBuilder responseBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).headers(responseHeaders);
        if (errorResponse != null && !errorResponse.isEmpty()) {
            return responseBuilder.body((Object)errorResponse);
        }
        if (originalResponse != null && !originalResponse.trim().isEmpty()) {
            return responseBuilder.body((Object)originalResponse);
        }
        return responseBuilder.build();
    }

    @ExceptionHandler
    ResponseEntity handle(NotAcceptableException exception) {
        this.logError((Exception)exception);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).headers(this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.BANK))).build();
    }

    @ExceptionHandler
    ResponseEntity handle(HttpRequestSigningException exception) {
        this.logError((Exception)exception);
        String errorText = "Exception during the request signing process";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    @ExceptionHandler
    ResponseEntity handle(UncheckedSSLHandshakeException exception) {
        this.logError((Exception)exception);
        String errorText = "Exception during the SSL handshake process";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.BANK);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    @ExceptionHandler
    ResponseEntity handle(UncheckedIOException exception) {
        this.logError(exception);
        String errorText = "Exception during the IO process";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    @ExceptionHandler
    ResponseEntity handle(UnsupportedOperationException exception) {
        this.logError(exception);
        String errorText = "This endpoint is not supported yet";
        HttpStatus httpStatus = HttpStatus.NOT_IMPLEMENTED;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    @ExceptionHandler(value={BadRequestException.class, AspspRegistrationException.class, AspspRegistrationNotFoundException.class, AdapterNotFoundException.class, IbanException.class})
    ResponseEntity<Object> handleAsBadRequest(Exception exception) {
        this.logError(exception);
        return this.handleAsBadRequest(exception.getMessage());
    }

    private ResponseEntity<Object> handleAsBadRequest(String errorText) {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logError((Exception)ex);
        return this.handleAsBadRequest("Required parameter '" + ex.getParameterName() + "' is missing");
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (ex instanceof MethodArgumentTypeMismatchException) {
            this.logError((Exception)ex);
            MethodArgumentTypeMismatchException exception = (MethodArgumentTypeMismatchException)ex;
            String errorMessage = "Illegal value '" + exception.getValue() + "' for parameter '" + exception.getName() + "'";
            Class parameterType = exception.getParameter().getParameterType();
            if (parameterType.isEnum()) {
                errorMessage = errorMessage + ", allowed values: " + Arrays.stream(parameterType.getEnumConstants()).map(Objects::toString).collect(Collectors.joining(", "));
            }
            return this.handleAsBadRequest(errorMessage);
        }
        return super.handleTypeMismatch(ex, headers, status, request);
    }

    @ExceptionHandler
    ResponseEntity handle(PsuPasswordEncodingException exception) {
        this.logError((Exception)exception);
        String errorText = "Exception during PSU password encryption";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    @ExceptionHandler
    ResponseEntity handle(Exception exception) {
        this.logError(exception);
        String errorText = "Server error";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        ErrorResponse errorResponse = this.buildErrorResponse(TppMessageCategoryTO.ERROR.name(), httpStatus.name(), errorText);
        HttpHeaders headers = this.addErrorOriginationHeader(new HttpHeaders(), ErrorOrigination.ADAPTER);
        return new ResponseEntity((Object)errorResponse, (MultiValueMap)headers, httpStatus);
    }

    private ErrorResponse buildErrorResponse(String category, String code, String text) {
        TppMessage tppMessage = new TppMessage();
        tppMessage.setCategory(category);
        tppMessage.setCode(code);
        tppMessage.setText(text);
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setTppMessages(Collections.singletonList(tppMessage));
        return errorResponse;
    }

    private HttpHeaders addErrorOriginationHeader(HttpHeaders httpHeaders, ErrorOrigination errorOrigination) {
        httpHeaders.add(ERROR_ORIGINATION_HEADER_NAME, errorOrigination.name());
        return httpHeaders;
    }

    private void logError(Exception exception) {
        String errorMessage = exception.getMessage() == null ? "" : exception.getMessage();
        this.logger.error((Object)errorMessage, (Throwable)exception);
        MDC.put((String)"errorMessage", (String)errorMessage);
    }

    private static enum ErrorOrigination {
        BANK,
        ADAPTER;

    }
}

