/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.mapper.psd2.Psd2Mapper;
import de.adorsys.xs2a.adapter.rest.psd2.Psd2PaymentApi;
import de.adorsys.xs2a.adapter.rest.psd2.model.AuthorisationsTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.PaymentInitiationRequestResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.PaymentInitiationTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.PaymentProductTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.PaymentServiceTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ScaStatusResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.StartScaProcessResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationTO;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.psd2.Psd2PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentProduct;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentService;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Psd2PaymentController
implements Psd2PaymentApi {
    private final Psd2PaymentInitiationService paymentInitiationService;
    private final HeadersMapper headersMapper;
    private final Psd2Mapper mapper = (Psd2Mapper)Mappers.getMapper(Psd2Mapper.class);

    public Psd2PaymentController(Psd2PaymentInitiationService paymentInitiationService, HeadersMapper headersMapper) {
        this.paymentInitiationService = paymentInitiationService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<PaymentInitiationRequestResponseTO> initiatePayment(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, Map<String, String> queryParameters, Map<String, String> headers, PaymentInitiationTO body) throws IOException {
        Response response = this.paymentInitiationService.initiatePayment(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), queryParameters, headers, this.mapper.toPaymentInitiation(body));
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toPaymentInitiationRequestResponseTO(arg_0));
    }

    private <T, U> ResponseEntity<U> responseEntity(Response<T> response, Function<T, U> bodyMapper) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.getStatusCode()).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(bodyMapper.apply(response.getBody()));
    }

    public ResponseEntity<PaymentInitiationRequestResponseTO> initiatePayment(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, Map<String, String> queryParameters, Map<String, String> headers, String body) throws IOException {
        Response response = this.paymentInitiationService.initiatePayment(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), queryParameters, headers, body);
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toPaymentInitiationRequestResponseTO(arg_0));
    }

    public ResponseEntity<Object> getPaymentInformation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.paymentInitiationService.getPaymentInformation(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, queryParameters, headers);
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toGetPaymentInformationResponseTO(arg_0));
    }

    public ResponseEntity<Object> getPaymentInitiationStatus(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.paymentInitiationService.getPaymentInitiationStatus(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, queryParameters, headers);
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toGetPaymentInitiationStatusResponseTO(arg_0));
    }

    public ResponseEntity<AuthorisationsTO> getPaymentInitiationAuthorisation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.paymentInitiationService.getPaymentInitiationAuthorisation(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, queryParameters, headers);
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toAuthorisationsTO(arg_0));
    }

    public ResponseEntity<StartScaProcessResponseTO> startPaymentAuthorisation(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisationTO body) throws IOException {
        Response response = this.paymentInitiationService.startPaymentAuthorisation(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, queryParameters, headers, this.mapper.toUpdateAuthorisation(body));
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toStartScaProcessResponseTO(arg_0));
    }

    public ResponseEntity<ScaStatusResponseTO> getPaymentInitiationScaStatus(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.paymentInitiationService.getPaymentInitiationScaStatus(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, authorisationId, queryParameters, headers);
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toScaStatusResponseTO(arg_0));
    }

    public ResponseEntity<UpdateAuthorisationResponseTO> updatePaymentPsuData(PaymentServiceTO paymentService, PaymentProductTO paymentProduct, String paymentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisationTO body) throws IOException {
        Response response = this.paymentInitiationService.updatePaymentPsuData(PaymentService.fromValue((String)paymentService.toString()), PaymentProduct.fromValue((String)paymentProduct.toString()), paymentId, authorisationId, queryParameters, headers, this.mapper.toUpdateAuthorisation(body));
        return this.responseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toUpdateAuthorisationResponseTO(arg_0));
    }
}

