/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.controller;

import de.adorsys.xs2a.adapter.mapper.HeadersMapper;
import de.adorsys.xs2a.adapter.mapper.psd2.Psd2Mapper;
import de.adorsys.xs2a.adapter.rest.psd2.Psd2AccountInformationApi;
import de.adorsys.xs2a.adapter.rest.psd2.model.AccountListTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.CardAccountDetailsResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.CardAccountListTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.CardAccountsTransactionsResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentInformationResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentStatusResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentsResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ConsentsTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ReadAccountBalanceResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ReadCardAccountBalanceResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.ScaStatusResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.StartScaProcessResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.TransactionDetailsResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationResponseTO;
import de.adorsys.xs2a.adapter.rest.psd2.model.UpdateAuthorisationTO;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import de.adorsys.xs2a.adapter.service.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
public class Psd2AccountInformationController
implements Psd2AccountInformationApi {
    private final Psd2AccountInformationService accountInformationService;
    private final HeadersMapper headersMapper;
    private final Psd2Mapper mapper = (Psd2Mapper)Mappers.getMapper(Psd2Mapper.class);

    public Psd2AccountInformationController(Psd2AccountInformationService accountInformationService, HeadersMapper headersMapper) {
        this.accountInformationService = accountInformationService;
        this.headersMapper = headersMapper;
    }

    public ResponseEntity<ConsentsResponseTO> createConsent(Map<String, String> queryParameters, Map<String, String> headers, ConsentsTO body) throws IOException {
        try {
            return this.createConsent0(queryParameters, headers, body);
        }
        catch (ErrorResponseException ex) {
            if (ex.getStatusCode() == 403 && ex.getMessage() != null && ex.getMessage().contains("TOKEN_INVALID")) {
                ConsentsResponse consentsResponse = new ConsentsResponse();
                consentsResponse.setLinks(Collections.singletonMap("preOauth", new HrefType("/oauth2/authorization-request-uri")));
                return this.toResponseEntity(new Response(200, (Object)consentsResponse, ResponseHeaders.emptyResponseHeaders()), arg_0 -> ((Psd2Mapper)this.mapper).toConsentsResponseTO(arg_0));
            }
            throw ex;
        }
    }

    private ResponseEntity<ConsentsResponseTO> createConsent0(Map<String, String> queryParameters, Map<String, String> headers, ConsentsTO body) throws IOException {
        Response response = this.accountInformationService.createConsent(queryParameters, headers, this.mapper.toConsents(body));
        ConsentsResponse consentsResponse = (ConsentsResponse)response.getBody();
        if (consentsResponse.getConsentId() == null && consentsResponse.getLinks() == null) {
            consentsResponse.setLinks(Collections.singletonMap("oauthConsent", new HrefType("/oauth2/authorization-request-uri")));
        }
        return this.toResponseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toConsentsResponseTO(arg_0));
    }

    private <T, U> ResponseEntity<U> toResponseEntity(Response<T> response, Function<? super T, ? extends U> bodyMapper) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(this.headersMapper.toHttpHeaders(response.getHeaders()))).body(bodyMapper.apply(response.getBody()));
    }

    public ResponseEntity<ConsentInformationResponseTO> getConsentInformation(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getConsentInformation(consentId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toConsentInformationResponseTO(arg_0));
    }

    public ResponseEntity<Void> deleteConsent(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.accountInformationService.deleteConsent(consentId, queryParameters, headers);
        return ResponseEntity.noContent().headers(this.headersMapper.toHttpHeaders(response.getHeaders())).build();
    }

    public ResponseEntity<ConsentStatusResponseTO> getConsentStatus(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getConsentStatus(consentId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toConsentStatusResponseTO(arg_0));
    }

    public ResponseEntity<StartScaProcessResponseTO> startConsentAuthorisation(String consentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisationTO body) throws IOException {
        return this.toResponseEntity(this.accountInformationService.startConsentAuthorisation(consentId, queryParameters, headers, this.mapper.toUpdateAuthorisation(body)), arg_0 -> ((Psd2Mapper)this.mapper).toStartScaProcessResponseTO(arg_0));
    }

    public ResponseEntity<ScaStatusResponseTO> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getConsentScaStatus(consentId, authorisationId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toScaStatusResponseTO(arg_0));
    }

    public ResponseEntity<UpdateAuthorisationResponseTO> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisationTO body) throws IOException {
        return this.toResponseEntity(this.accountInformationService.updateConsentsPsuData(consentId, authorisationId, queryParameters, headers, this.mapper.toUpdateAuthorisation(body)), arg_0 -> ((Psd2Mapper)this.mapper).toUpdateAuthorisationResponseTO(arg_0));
    }

    public ResponseEntity<CardAccountListTO> getCardAccountList(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getCardAccountList(queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toCardAccountListTO(arg_0));
    }

    public ResponseEntity<CardAccountDetailsResponseTO> getCardAccountDetails(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getCardAccountDetails(accountId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toCardAccountDetailsResponseTO(arg_0));
    }

    public ResponseEntity<ReadCardAccountBalanceResponseTO> getCardAccountBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getCardAccountBalances(accountId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toReadCardAccountBalanceResponseTO(arg_0));
    }

    public ResponseEntity<CardAccountsTransactionsResponseTO> getCardAccountTransactionList(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getCardAccountTransactionList(accountId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toCardAccountsTransactionsResponseTO(arg_0));
    }

    public ResponseEntity<AccountListTO> getAccountList(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getAccounts(queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toAccountListTO(arg_0));
    }

    public ResponseEntity<ReadAccountBalanceResponseTO> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.toResponseEntity(this.accountInformationService.getBalances(accountId, queryParameters, headers), arg_0 -> ((Psd2Mapper)this.mapper).toReadAccountBalanceResponseTO(arg_0));
    }

    public ResponseEntity getTransactionList(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.accountInformationService.getTransactions(accountId, queryParameters, headers);
        if (response.getBody() instanceof TransactionsResponse) {
            return this.toResponseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toTransactionsResponseTO(arg_0));
        }
        return this.toResponseEntity(response, Function.identity());
    }

    public ResponseEntity<TransactionDetailsResponseTO> getTransactionDetails(String accountId, String transactionId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        Response response = this.accountInformationService.getTransactionDetails(accountId, transactionId, queryParameters, headers);
        return this.toResponseEntity(response, arg_0 -> ((Psd2Mapper)this.mapper).toTransactionDetailsResponseTO(arg_0));
    }
}

