/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.verlag;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.http.Interceptor;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.impl.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.verlag.VerlagMapper;
import de.adorsys.xs2a.adapter.verlag.VerlagServiceProvider;
import de.adorsys.xs2a.adapter.verlag.model.VerlagOK200TransactionDetails;
import de.adorsys.xs2a.adapter.verlag.model.VerlagTransactionResponse200Json;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mapstruct.factory.Mappers;

public class VerlagAccountInformationService
extends BaseAccountInformationService {
    private final VerlagMapper verlagMapper = (VerlagMapper)Mappers.getMapper(VerlagMapper.class);
    private AbstractMap.SimpleImmutableEntry<String, String> apiKey;

    public VerlagAccountInformationService(Aspsp aspsp, AbstractMap.SimpleImmutableEntry<String, String> apiKey, HttpClientFactory httpClientFactory, List<Interceptor> interceptors, LinksRewriter linksRewriter) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId(), null, VerlagServiceProvider.SUPPORTED_CIPHER_SUITES), interceptors, linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
        this.apiKey = apiKey;
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionListAsString(accountId, this.modifyAcceptHeader(requestHeaders), requestParams);
    }

    private RequestHeaders modifyAcceptHeader(RequestHeaders requestHeaders) {
        if (this.isTextPlain(requestHeaders)) {
            return requestHeaders;
        }
        return this.setAcceptJson(requestHeaders);
    }

    private boolean isTextPlain(RequestHeaders requestHeaders) {
        Optional acceptHeaderOptional = requestHeaders.get("Accept");
        return acceptHeaderOptional.isPresent() && "text/plain".equalsIgnoreCase((String)acceptHeaderOptional.get());
    }

    public Response<TransactionsResponse200Json> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionList(accountId, requestHeaders, requestParams, VerlagTransactionResponse200Json.class, this.verlagMapper::toTransactionsResponse200Json);
    }

    public Response<OK200TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionDetails(accountId, transactionId, requestHeaders, requestParams, VerlagOK200TransactionDetails.class, this.verlagMapper::toOK200TransactionDetails);
    }

    private RequestHeaders setAcceptJson(RequestHeaders requestHeaders) {
        Map headersMap = requestHeaders.toMap();
        headersMap.put("Accept", "application/json");
        return RequestHeaders.fromMap((Map)headersMap);
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        return this.addApiKey(headers);
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        return this.addApiKey(headers);
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        return this.addApiKey(headers);
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        return this.addApiKey(headers);
    }

    private Map<String, String> addApiKey(Map<String, String> headers) {
        headers.put(this.apiKey.getKey(), this.apiKey.getValue());
        return headers;
    }
}

