/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.verlag;

import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.DownloadService;
import de.adorsys.xs2a.adapter.api.DownloadServiceProvider;
import de.adorsys.xs2a.adapter.api.PaymentInitiationService;
import de.adorsys.xs2a.adapter.api.config.AdapterConfig;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.http.Interceptor;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.impl.AbstractAdapterServiceProvider;
import de.adorsys.xs2a.adapter.impl.BaseDownloadService;
import de.adorsys.xs2a.adapter.verlag.PsuIdTypeHeaderInterceptor;
import de.adorsys.xs2a.adapter.verlag.VerlagAccountInformationService;
import de.adorsys.xs2a.adapter.verlag.VerlagPaymentInitiationService;
import java.util.AbstractMap;

public class VerlagServiceProvider
extends AbstractAdapterServiceProvider
implements DownloadServiceProvider {
    private static final String VERLAG_API_KEY_NAME = "verlag.apikey.name";
    private static final String VERLAG_API_KEY_VALUE = "verlag.apikey.value";
    static final String[] SUPPORTED_CIPHER_SUITES = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"};
    private static final AbstractMap.SimpleImmutableEntry<String, String> apiKeyEntry;
    private final PsuIdTypeHeaderInterceptor psuIdTypeHeaderInterceptor = new PsuIdTypeHeaderInterceptor();

    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        return new VerlagAccountInformationService(aspsp, apiKeyEntry, httpClientFactory, this.getInterceptors(aspsp, new Interceptor[]{this.psuIdTypeHeaderInterceptor}), linksRewriter);
    }

    public PaymentInitiationService getPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        return new VerlagPaymentInitiationService(aspsp, apiKeyEntry, httpClientFactory, this.getInterceptors(aspsp, new Interceptor[]{this.psuIdTypeHeaderInterceptor}), linksRewriter);
    }

    public DownloadService getDownloadService(String baseUrl, HttpClientFactory httpClientFactory) {
        return new BaseDownloadService(baseUrl, httpClientFactory.getHttpClient(this.getAdapterId(), null, SUPPORTED_CIPHER_SUITES), httpClientFactory.getHttpClientConfig().getLogSanitizer());
    }

    public String getAdapterId() {
        return "verlag-adapter";
    }

    static {
        String apiKeyName = AdapterConfig.readProperty((String)VERLAG_API_KEY_NAME, (String)"");
        String apiKeyValue = AdapterConfig.readProperty((String)VERLAG_API_KEY_VALUE, (String)"");
        apiKeyEntry = new AbstractMap.SimpleImmutableEntry<String, String>(apiKeyName, apiKeyValue);
    }
}

