/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparkasse;

import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.Oauth2ServiceProvider;
import de.adorsys.xs2a.adapter.api.PaymentInitiationService;
import de.adorsys.xs2a.adapter.api.PaymentInitiationServiceProvider;
import de.adorsys.xs2a.adapter.api.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.api.http.HttpClient;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.impl.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.sparkasse.SparkasseOauth2Service;
import de.adorsys.xs2a.adapter.sparkasse.SparkassePaymentInitiationService;

public class SparkasseServiceProvider
implements AccountInformationServiceProvider,
PaymentInitiationServiceProvider,
Oauth2ServiceProvider {
    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new BaseAccountInformationService(aspsp, httpClientFactory.getHttpClient(this.getAdapterId()), linksRewriter);
    }

    public PaymentInitiationService getPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new SparkassePaymentInitiationService(aspsp, httpClientFactory.getHttpClient(this.getAdapterId()), linksRewriter);
    }

    public Oauth2Service getOauth2Service(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore) {
        HttpClient httpClient = httpClientFactory.getHttpClient(this.getAdapterId());
        return SparkasseOauth2Service.create(aspsp, httpClient, keyStore);
    }

    public String getAdapterId() {
        return "sparkasse-adapter";
    }
}

