/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparkasse;

import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.api.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.api.http.HttpClient;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.api.validation.Validation;
import de.adorsys.xs2a.adapter.impl.BaseOauth2Service;
import de.adorsys.xs2a.adapter.impl.CertificateSubjectClientIdOauth2Service;
import de.adorsys.xs2a.adapter.impl.Oauth2ServiceDecorator;
import de.adorsys.xs2a.adapter.impl.PkceOauth2Service;
import de.adorsys.xs2a.adapter.impl.ScopeWithResourceIdOauth2Service;
import de.adorsys.xs2a.adapter.impl.http.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class SparkasseOauth2Service
extends Oauth2ServiceDecorator
implements PkceOauth2Extension {
    private static final String AIS_SCOPE_PREFIX = "AIS: ";
    private static final String PIS_SCOPE_PREFIX = "PIS: ";

    private SparkasseOauth2Service(Oauth2Service oauth2Service) {
        super(oauth2Service);
    }

    public static SparkasseOauth2Service create(Aspsp aspsp, HttpClient httpClient, Pkcs12KeyStore keyStore) {
        BaseOauth2Service baseOauth2Service = new BaseOauth2Service(aspsp, httpClient);
        CertificateSubjectClientIdOauth2Service clientIdOauth2Service = new CertificateSubjectClientIdOauth2Service((Oauth2Service)baseOauth2Service, keyStore);
        PkceOauth2Service pkceOauth2Service = new PkceOauth2Service((Oauth2Service)clientIdOauth2Service);
        ScopeWithResourceIdOauth2Service scopeOauth2Service = new ScopeWithResourceIdOauth2Service((Oauth2Service)pkceOauth2Service, AIS_SCOPE_PREFIX, PIS_SCOPE_PREFIX);
        return new SparkasseOauth2Service((Oauth2Service)scopeOauth2Service);
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        Validation.requireValid((List)this.validateGetAuthorizationRequestUri(headers, parameters));
        return UriBuilder.fromUri((URI)this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).renameQueryParam("response_type", "responseType").renameQueryParam("client_id", "clientId").build();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        return this.oauth2Service.getToken(headers, parameters);
    }
}

