/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparkasse;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.PaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.api.model.PaymentProduct;
import de.adorsys.xs2a.adapter.api.model.PaymentService;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.impl.BasePaymentInitiationService;
import de.adorsys.xs2a.adapter.sparkasse.SparkasseMapper;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkassePaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseSelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseStartScaprocessResponse;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseUpdatePsuAuthenticationResponse;
import org.mapstruct.factory.Mappers;

public class SparkassePaymentInitiationService
extends BasePaymentInitiationService {
    private final SparkasseMapper sparkasseMapper = (SparkasseMapper)Mappers.getMapper(SparkasseMapper.class);

    public SparkassePaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId()), linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
    }

    public Response<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, RequestHeaders requestHeaders, RequestParams requestParams, Object body) {
        if (paymentService == PaymentService.PAYMENTS && this.isXml(paymentProduct) && body instanceof String) {
            String xml = (String)body;
            body = this.resolveReqdExctnDt(xml);
        }
        return super.initiatePayment(paymentService, paymentProduct, requestHeaders, requestParams, body, SparkassePaymentInitationRequestResponse201.class, this.sparkasseMapper::toPaymentInitationRequestResponse201);
    }

    public Response<StartScaprocessResponse> startPaymentAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.startPaymentAuthorisation(paymentService, paymentProduct, paymentId, requestHeaders, requestParams, SparkasseStartScaprocessResponse.class, this.sparkasseMapper::toStartScaprocessResponse);
    }

    public Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication, SparkasseUpdatePsuAuthenticationResponse.class, this.sparkasseMapper::toUpdatePsuAuthenticationResponse);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return super.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod, SparkasseSelectPsuAuthenticationMethodResponse.class, this.sparkasseMapper::toSelectPsuAuthenticationMethodResponse);
    }

    private String resolveReqdExctnDt(String body) {
        return body.replaceAll("<ReqdExctnDt>.+</ReqdExctnDt>", "<ReqdExctnDt>1999-01-01</ReqdExctnDt>");
    }
}

