/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparkasse;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.AuthenticationObject;
import de.adorsys.xs2a.adapter.api.model.AuthenticationType;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.ConsentsResponse201;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.PaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.api.model.TppMessage2XX;
import de.adorsys.xs2a.adapter.api.model.TransactionDetailsBody;
import de.adorsys.xs2a.adapter.api.model.Transactions;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.sparkasse.SparkasseMapper;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseAccountReport;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseAuthenticationObject;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseAuthenticationType;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseConsentsResponse201;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseOK200TransactionDetails;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkassePaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseSelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseStartScaprocessResponse;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseTransactionDetails;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseTransactionResponse200Json;
import de.adorsys.xs2a.adapter.sparkasse.model.SparkasseUpdatePsuAuthenticationResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparkasseMapperImpl
implements SparkasseMapper {
    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(SparkasseTransactionResponse200Json value) {
        Map<String, HrefType> map;
        if (value == null) {
            return null;
        }
        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();
        transactionsResponse200Json.setAccount(value.getAccount());
        transactionsResponse200Json.setTransactions(this.sparkasseAccountReportToAccountReport(value.getTransactions()));
        List<Balance> list = value.getBalances();
        if (list != null) {
            transactionsResponse200Json.setBalances(new ArrayList<Balance>(list));
        }
        if ((map = value.getLinks()) != null) {
            transactionsResponse200Json.setLinks(new HashMap<String, HrefType>(map));
        }
        return transactionsResponse200Json;
    }

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(SparkasseOK200TransactionDetails value) {
        if (value == null) {
            return null;
        }
        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();
        oK200TransactionDetails.setTransactionsDetails(this.toTransactionDetailsBody(value.getTransactionsDetails()));
        return oK200TransactionDetails;
    }

    @Override
    public Transactions toTransactions(SparkasseTransactionDetails value) {
        if (value == null) {
            return null;
        }
        Transactions transactions = new Transactions();
        transactions.setTransactionId(value.getTransactionId());
        transactions.setEntryReference(value.getEntryReference());
        transactions.setEndToEndId(value.getEndToEndId());
        transactions.setMandateId(value.getMandateId());
        transactions.setCheckId(value.getCheckId());
        transactions.setCreditorId(value.getCreditorId());
        transactions.setBookingDate(value.getBookingDate());
        transactions.setValueDate(value.getValueDate());
        transactions.setTransactionAmount(value.getTransactionAmount());
        List<ReportExchangeRate> list = value.getCurrencyExchange();
        if (list != null) {
            transactions.setCurrencyExchange(new ArrayList<ReportExchangeRate>(list));
        }
        transactions.setCreditorName(value.getCreditorName());
        transactions.setCreditorAccount(value.getCreditorAccount());
        transactions.setCreditorAgent(value.getCreditorAgent());
        transactions.setUltimateCreditor(value.getUltimateCreditor());
        transactions.setDebtorName(value.getDebtorName());
        transactions.setDebtorAccount(value.getDebtorAccount());
        transactions.setDebtorAgent(value.getDebtorAgent());
        transactions.setUltimateDebtor(value.getUltimateDebtor());
        transactions.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        List<String> list1 = value.getRemittanceInformationUnstructuredArray();
        if (list1 != null) {
            transactions.setRemittanceInformationUnstructuredArray(new ArrayList<String>(list1));
        }
        transactions.setRemittanceInformationStructured(this.map(value.getRemittanceInformationStructured()));
        List<RemittanceInformationStructured> list2 = value.getRemittanceInformationStructuredArray();
        if (list2 != null) {
            transactions.setRemittanceInformationStructuredArray(new ArrayList<RemittanceInformationStructured>(list2));
        }
        transactions.setAdditionalInformation(value.getAdditionalInformation());
        transactions.setAdditionalInformationStructured(value.getAdditionalInformationStructured());
        transactions.setPurposeCode(value.getPurposeCode());
        transactions.setBankTransactionCode(value.getBankTransactionCode());
        transactions.setProprietaryBankTransactionCode(value.getProprietaryBankTransactionCode());
        transactions.setBalanceAfterTransaction(value.getBalanceAfterTransaction());
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            transactions.setLinks(new HashMap<String, HrefType>(map));
        }
        return transactions;
    }

    @Override
    public TransactionDetailsBody toTransactionDetailsBody(SparkasseTransactionDetails value) {
        if (value == null) {
            return null;
        }
        TransactionDetailsBody transactionDetailsBody = new TransactionDetailsBody();
        transactionDetailsBody.setTransactionDetails(this.toTransactions(value));
        return transactionDetailsBody;
    }

    @Override
    public AuthenticationType toAuthenticationType(SparkasseAuthenticationType value) {
        AuthenticationType authenticationType;
        if (value == null) {
            return null;
        }
        switch (value) {
            case PUSH_DEC: {
                authenticationType = AuthenticationType.PUSH_OTP;
                break;
            }
            case SMS_OTP: {
                authenticationType = AuthenticationType.SMS_OTP;
                break;
            }
            case CHIP_OTP: {
                authenticationType = AuthenticationType.CHIP_OTP;
                break;
            }
            case PHOTO_OTP: {
                authenticationType = AuthenticationType.PHOTO_OTP;
                break;
            }
            case PUSH_OTP: {
                authenticationType = AuthenticationType.PUSH_OTP;
                break;
            }
            case SMTP_OTP: {
                authenticationType = AuthenticationType.SMTP_OTP;
                break;
            }
            case EMAIL: {
                authenticationType = AuthenticationType.EMAIL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + value);
            }
        }
        return authenticationType;
    }

    @Override
    public ConsentsResponse201 toConsentsResponse201(SparkasseConsentsResponse201 value) {
        if (value == null) {
            return null;
        }
        ConsentsResponse201 consentsResponse201 = new ConsentsResponse201();
        consentsResponse201.setConsentStatus(value.getConsentStatus());
        consentsResponse201.setConsentId(value.getConsentId());
        consentsResponse201.setScaMethods(this.sparkasseAuthenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        consentsResponse201.setChosenScaMethod(this.sparkasseAuthenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        consentsResponse201.setChallengeData(value.getChallengeData());
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            consentsResponse201.setLinks(new HashMap<String, HrefType>(map));
        }
        consentsResponse201.setPsuMessage(value.getPsuMessage());
        return consentsResponse201;
    }

    @Override
    public PaymentInitationRequestResponse201 toPaymentInitationRequestResponse201(SparkassePaymentInitationRequestResponse201 value) {
        if (value == null) {
            return null;
        }
        PaymentInitationRequestResponse201 paymentInitationRequestResponse201 = new PaymentInitationRequestResponse201();
        paymentInitationRequestResponse201.setTransactionStatus(value.getTransactionStatus());
        paymentInitationRequestResponse201.setPaymentId(value.getPaymentId());
        paymentInitationRequestResponse201.setTransactionFees(value.getTransactionFees());
        paymentInitationRequestResponse201.setCurrencyConversionFee(value.getCurrencyConversionFee());
        paymentInitationRequestResponse201.setEstimatedTotalAmount(value.getEstimatedTotalAmount());
        paymentInitationRequestResponse201.setEstimatedInterbankSettlementAmount(value.getEstimatedInterbankSettlementAmount());
        paymentInitationRequestResponse201.setTransactionFeeIndicator(value.getTransactionFeeIndicator());
        paymentInitationRequestResponse201.setScaMethods(this.sparkasseAuthenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        paymentInitationRequestResponse201.setChosenScaMethod(this.sparkasseAuthenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        paymentInitationRequestResponse201.setChallengeData(value.getChallengeData());
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            paymentInitationRequestResponse201.setLinks(new HashMap<String, HrefType>(map));
        }
        paymentInitationRequestResponse201.setPsuMessage(value.getPsuMessage());
        List<TppMessage2XX> list1 = value.getTppMessages();
        if (list1 != null) {
            paymentInitationRequestResponse201.setTppMessages(new ArrayList<TppMessage2XX>(list1));
        }
        return paymentInitationRequestResponse201;
    }

    @Override
    public SelectPsuAuthenticationMethodResponse toSelectPsuAuthenticationMethodResponse(SparkasseSelectPsuAuthenticationMethodResponse value) {
        if (value == null) {
            return null;
        }
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = new SelectPsuAuthenticationMethodResponse();
        selectPsuAuthenticationMethodResponse.setTransactionFees(value.getTransactionFees());
        selectPsuAuthenticationMethodResponse.setCurrencyConversionFees(value.getCurrencyConversionFees());
        selectPsuAuthenticationMethodResponse.setEstimatedTotalAmount(value.getEstimatedTotalAmount());
        selectPsuAuthenticationMethodResponse.setEstimatedInterbankSettlementAmount(value.getEstimatedInterbankSettlementAmount());
        selectPsuAuthenticationMethodResponse.setChosenScaMethod(this.sparkasseAuthenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        selectPsuAuthenticationMethodResponse.setChallengeData(value.getChallengeData());
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            selectPsuAuthenticationMethodResponse.setLinks(new HashMap<String, HrefType>(map));
        }
        selectPsuAuthenticationMethodResponse.setScaStatus(value.getScaStatus());
        selectPsuAuthenticationMethodResponse.setPsuMessage(value.getPsuMessage());
        return selectPsuAuthenticationMethodResponse;
    }

    @Override
    public StartScaprocessResponse toStartScaprocessResponse(SparkasseStartScaprocessResponse value) {
        if (value == null) {
            return null;
        }
        StartScaprocessResponse startScaprocessResponse = new StartScaprocessResponse();
        startScaprocessResponse.setScaStatus(value.getScaStatus());
        startScaprocessResponse.setAuthorisationId(value.getAuthorisationId());
        startScaprocessResponse.setScaMethods(this.sparkasseAuthenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        startScaprocessResponse.setChosenScaMethod(this.sparkasseAuthenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        startScaprocessResponse.setChallengeData(value.getChallengeData());
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            startScaprocessResponse.setLinks(new HashMap<String, HrefType>(map));
        }
        startScaprocessResponse.setPsuMessage(value.getPsuMessage());
        return startScaprocessResponse;
    }

    @Override
    public UpdatePsuAuthenticationResponse toUpdatePsuAuthenticationResponse(SparkasseUpdatePsuAuthenticationResponse value) {
        if (value == null) {
            return null;
        }
        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = new UpdatePsuAuthenticationResponse();
        updatePsuAuthenticationResponse.setTransactionFees(value.getTransactionFees());
        updatePsuAuthenticationResponse.setCurrencyConversionFees(value.getCurrencyConversionFees());
        updatePsuAuthenticationResponse.setEstimatedTotalAmount(value.getEstimatedTotalAmount());
        updatePsuAuthenticationResponse.setEstimatedInterbankSettlementAmount(value.getEstimatedInterbankSettlementAmount());
        updatePsuAuthenticationResponse.setChosenScaMethod(this.sparkasseAuthenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        updatePsuAuthenticationResponse.setChallengeData(value.getChallengeData());
        updatePsuAuthenticationResponse.setScaMethods(this.sparkasseAuthenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        Map<String, HrefType> map = value.getLinks();
        if (map != null) {
            updatePsuAuthenticationResponse.setLinks(new HashMap<String, HrefType>(map));
        }
        updatePsuAuthenticationResponse.setScaStatus(value.getScaStatus());
        updatePsuAuthenticationResponse.setPsuMessage(value.getPsuMessage());
        updatePsuAuthenticationResponse.setAuthorisationId(value.getAuthorisationId());
        return updatePsuAuthenticationResponse;
    }

    protected List<Transactions> sparkasseTransactionDetailsListToTransactionsList(List<SparkasseTransactionDetails> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Transactions> list1 = new ArrayList<Transactions>(list.size());
        for (SparkasseTransactionDetails sparkasseTransactionDetails : list) {
            list1.add(this.toTransactions(sparkasseTransactionDetails));
        }
        return list1;
    }

    protected AccountReport sparkasseAccountReportToAccountReport(SparkasseAccountReport sparkasseAccountReport) {
        if (sparkasseAccountReport == null) {
            return null;
        }
        AccountReport accountReport = new AccountReport();
        accountReport.setBooked(this.sparkasseTransactionDetailsListToTransactionsList(sparkasseAccountReport.getBooked()));
        accountReport.setPending(this.sparkasseTransactionDetailsListToTransactionsList(sparkasseAccountReport.getPending()));
        Map<String, HrefType> map = sparkasseAccountReport.getLinks();
        if (map != null) {
            accountReport.setLinks(new HashMap<String, HrefType>(map));
        }
        return accountReport;
    }

    protected AuthenticationObject sparkasseAuthenticationObjectToAuthenticationObject(SparkasseAuthenticationObject sparkasseAuthenticationObject) {
        if (sparkasseAuthenticationObject == null) {
            return null;
        }
        AuthenticationObject authenticationObject = new AuthenticationObject();
        authenticationObject.setAuthenticationType(this.toAuthenticationType(sparkasseAuthenticationObject.getAuthenticationType()));
        authenticationObject.setAuthenticationVersion(sparkasseAuthenticationObject.getAuthenticationVersion());
        authenticationObject.setAuthenticationMethodId(sparkasseAuthenticationObject.getAuthenticationMethodId());
        authenticationObject.setName(sparkasseAuthenticationObject.getName());
        authenticationObject.setExplanation(sparkasseAuthenticationObject.getExplanation());
        return authenticationObject;
    }

    protected List<AuthenticationObject> sparkasseAuthenticationObjectListToAuthenticationObjectList(List<SparkasseAuthenticationObject> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AuthenticationObject> list1 = new ArrayList<AuthenticationObject>(list.size());
        for (SparkasseAuthenticationObject sparkasseAuthenticationObject : list) {
            list1.add(this.sparkasseAuthenticationObjectToAuthenticationObject(sparkasseAuthenticationObject));
        }
        return list1;
    }
}

