/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparda;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.Consents;
import de.adorsys.xs2a.adapter.api.model.ConsentsResponse201;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.impl.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.impl.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.impl.http.StringUri;
import de.adorsys.xs2a.adapter.sparda.SpardaJwtService;
import de.adorsys.xs2a.adapter.sparda.SpardaMapper;
import de.adorsys.xs2a.adapter.sparda.model.SpardaOK200TransactionDetails;
import de.adorsys.xs2a.adapter.sparda.model.SpardaTransactionResponse200Json;
import java.util.Map;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;

public class SpardaAccountInformationService
extends BaseAccountInformationService {
    private static final String AIS_SCOPE = "ais";
    private static final String BEARER_TOKEN_TYPE_PREFIX = "Bearer ";
    private final SpardaJwtService spardaJwtService;
    private final SpardaMapper spardaMapper = (SpardaMapper)Mappers.getMapper(SpardaMapper.class);
    private final ResponseHandlers responseHandlers;

    public SpardaAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter, SpardaJwtService spardaJwtService) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId()), linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
        this.spardaJwtService = spardaJwtService;
        this.responseHandlers = new ResponseHandlers(httpClientFactory.getHttpClientConfig().getLogSanitizer());
    }

    public Response<ConsentsResponse201> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        if (this.isOauthPreStep(requestHeaders)) {
            requestHeaders = this.modifyPsuId(requestHeaders);
        }
        String idpUri = StringUri.appendQueryParam((String)this.getIdpUri(), (String)"scope", (String)AIS_SCOPE);
        return this.createConsent(requestHeaders, requestParams, body, Function.identity(), this.responseHandlers.consentCreationResponseHandler(idpUri, ConsentsResponse201.class));
    }

    public Response<TransactionsResponse200Json> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionList(accountId, requestHeaders, requestParams, SpardaTransactionResponse200Json.class, this.spardaMapper::toTransactionsResponse200Json);
    }

    public Response<OK200TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionDetails(accountId, transactionId, requestHeaders, requestParams, SpardaOK200TransactionDetails.class, this.spardaMapper::toOK200TransactionDetails);
    }

    private boolean isOauthPreStep(RequestHeaders requestHeaders) {
        return requestHeaders.get("Authorization").map(authHeader -> authHeader.startsWith(BEARER_TOKEN_TYPE_PREFIX)).orElse(false);
    }

    private RequestHeaders modifyPsuId(RequestHeaders requestHeaders) {
        String token = requestHeaders.getAuthorization().map(this::getBearerToken).orElse(null);
        Map headersMap = requestHeaders.toMap();
        headersMap.put("PSU-ID".toLowerCase(), this.spardaJwtService.getPsuId(token));
        return RequestHeaders.fromMap((Map)headersMap);
    }

    private String getBearerToken(String authorizationHeader) {
        return authorizationHeader.substring(BEARER_TOKEN_TYPE_PREFIX.length());
    }
}

