/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparda;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.PaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.api.model.PaymentProduct;
import de.adorsys.xs2a.adapter.api.model.PaymentService;
import de.adorsys.xs2a.adapter.impl.BasePaymentInitiationService;
import de.adorsys.xs2a.adapter.impl.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.impl.http.StringUri;
import de.adorsys.xs2a.adapter.sparda.SpardaJwtService;
import java.util.Map;
import java.util.function.Function;

public class SpardaPaymentInitiationService
extends BasePaymentInitiationService {
    private static final String PIS_SCOPE = "pis";
    private static final String BEARER_TOKEN_TYPE_PREFIX = "Bearer ";
    private final SpardaJwtService spardaJwtService;
    private final ResponseHandlers responseHandlers;

    public SpardaPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter, SpardaJwtService spardaJwtService) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId()), linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
        this.spardaJwtService = spardaJwtService;
        this.responseHandlers = new ResponseHandlers(httpClientFactory.getHttpClientConfig().getLogSanitizer());
    }

    public Response<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, RequestHeaders requestHeaders, RequestParams requestParams, Object body) {
        if (this.isOauthPreStep(requestHeaders)) {
            requestHeaders = this.modifyPsuId(requestHeaders);
        }
        String idpUri = StringUri.appendQueryParam((String)this.getIdpUri(), (String)"scope", (String)PIS_SCOPE);
        return this.initiatePayment(paymentService, paymentProduct, body, requestHeaders, requestParams, Function.identity(), this.responseHandlers.paymentInitiationResponseHandler(idpUri, PaymentInitationRequestResponse201.class));
    }

    private boolean isOauthPreStep(RequestHeaders requestHeaders) {
        return requestHeaders.get("Authorization").map(authHeader -> authHeader.startsWith(BEARER_TOKEN_TYPE_PREFIX)).orElse(false);
    }

    private RequestHeaders modifyPsuId(RequestHeaders requestHeaders) {
        String token = requestHeaders.getAuthorization().map(this::getBearerToken).orElse(null);
        Map headersMap = requestHeaders.toMap();
        headersMap.put("PSU-ID".toLowerCase(), this.spardaJwtService.getPsuId(token));
        return RequestHeaders.fromMap((Map)headersMap);
    }

    private String getBearerToken(String authorizationHeader) {
        return authorizationHeader.substring(BEARER_TOKEN_TYPE_PREFIX.length());
    }
}

