/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparda;

import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.api.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.api.http.HttpClient;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.http.HttpLogSanitizer;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.Scope;
import de.adorsys.xs2a.adapter.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.api.validation.Validation;
import de.adorsys.xs2a.adapter.api.validation.ValidationError;
import de.adorsys.xs2a.adapter.impl.BaseOauth2Service;
import de.adorsys.xs2a.adapter.impl.CertificateSubjectClientIdOauth2Service;
import de.adorsys.xs2a.adapter.impl.http.StringUri;
import de.adorsys.xs2a.adapter.impl.http.UriBuilder;
import de.adorsys.xs2a.adapter.sparda.SpardaPkceOauth2Service;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SpardaOauth2Service
implements Oauth2Service,
PkceOauth2Extension {
    private static final EnumMap<Scope, Scope> SCOPE_MAPPING = SpardaOauth2Service.initiateScopeMapping();
    protected static final String UNSUPPORTED_SCOPE_VALUE_ERROR_MESSAGE = "Scope value [%s] is not supported";
    private final Aspsp aspsp;
    private final Oauth2Service oauth2Service;
    private final String clientId;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;

    private SpardaOauth2Service(Aspsp aspsp, Oauth2Service oauth2Service, String clientId) {
        this.aspsp = aspsp;
        this.oauth2Service = oauth2Service;
        this.clientId = clientId;
        String[] idpHosts = Objects.requireNonNull(aspsp.getIdpUrl()).trim().split("\\s+");
        if (idpHosts.length != 2) {
            throw new IllegalArgumentException("IDP must consist of two hosts separated by a whitespace");
        }
        this.authorizationEndpoint = StringUri.fromElements((Object[])new Object[]{idpHosts[0], "/oauth2/authorize"});
        this.tokenEndpoint = StringUri.fromElements((Object[])new Object[]{idpHosts[1], "/oauth2/token"});
    }

    public static SpardaOauth2Service create(Aspsp aspsp, HttpClientFactory httpClientFactory, String clientId) {
        HttpClient httpClient = httpClientFactory.getHttpClient(aspsp.getAdapterId());
        HttpLogSanitizer logSanitizer = httpClientFactory.getHttpClientConfig().getLogSanitizer();
        Pkcs12KeyStore keyStore = httpClientFactory.getHttpClientConfig().getKeyStore();
        BaseOauth2Service baseOauth2Service = new BaseOauth2Service(aspsp, httpClient, logSanitizer);
        CertificateSubjectClientIdOauth2Service clientIdOauth2Service = new CertificateSubjectClientIdOauth2Service((Oauth2Service)baseOauth2Service, keyStore);
        SpardaPkceOauth2Service pkceOauth2Service = new SpardaPkceOauth2Service((Oauth2Service)clientIdOauth2Service);
        return new SpardaOauth2Service(aspsp, (Oauth2Service)pkceOauth2Service, clientId);
    }

    private static EnumMap<Scope, Scope> initiateScopeMapping() {
        EnumMap<Scope, Scope> scopeMapping = new EnumMap<Scope, Scope>(Scope.class);
        scopeMapping.put(Scope.AIS, Scope.AIS);
        scopeMapping.put(Scope.AIS_BALANCES, Scope.AIS);
        scopeMapping.put(Scope.AIS_TRANSACTIONS, Scope.AIS);
        scopeMapping.put(Scope.PIS, Scope.PIS);
        return scopeMapping;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        Validation.requireValid(this.validateGetAuthorizationRequestUri(headers, parameters));
        parameters.setAuthorizationEndpoint(this.authorizationEndpoint);
        parameters.setClientId(this.clientId);
        parameters.setScope(this.mapScope(parameters.getScope()));
        return UriBuilder.fromUri((URI)this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("bic", this.aspsp.getBic()).build();
    }

    private String mapScope(String scope) {
        return SCOPE_MAPPING.get(Scope.fromValue((String)scope)).getValue();
    }

    public List<ValidationError> validateGetAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        String scope;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (StringUtils.isBlank((CharSequence)parameters.getRedirectUri())) {
            validationErrors.add(ValidationError.required((String)"redirect_uri"));
        }
        if (StringUtils.isBlank((CharSequence)(scope = parameters.getScope()))) {
            validationErrors.add(ValidationError.required((String)"scope"));
        } else if (!Scope.contains((String)scope)) {
            validationErrors.add(new ValidationError(ValidationError.Code.NOT_SUPPORTED, "scope", String.format(UNSUPPORTED_SCOPE_VALUE_ERROR_MESSAGE, scope)));
        }
        return validationErrors;
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        Validation.requireValid(this.validateGetToken(headers, parameters));
        parameters.setClientId(this.clientId);
        parameters.setTokenEndpoint(this.tokenEndpoint);
        return this.oauth2Service.getToken(headers, parameters);
    }

    public List<ValidationError> validateGetToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        if (parameters.getAuthorizationCode() != null && StringUtils.isBlank((CharSequence)parameters.getRedirectUri())) {
            return Collections.singletonList(ValidationError.required((String)"redirect_uri"));
        }
        return Collections.emptyList();
    }

    public byte[] octetSequence() {
        return SpardaPkceOauth2Service.OCTET_SEQUENCE;
    }
}

