/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.sparda;

import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.Oauth2ServiceProvider;
import de.adorsys.xs2a.adapter.api.PaymentInitiationService;
import de.adorsys.xs2a.adapter.api.config.AdapterConfig;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.impl.AbstractAdapterServiceProvider;
import de.adorsys.xs2a.adapter.sparda.SpardaAccountInformationService;
import de.adorsys.xs2a.adapter.sparda.SpardaJwtService;
import de.adorsys.xs2a.adapter.sparda.SpardaOauth2Service;
import de.adorsys.xs2a.adapter.sparda.SpardaPaymentInitiationService;

public class SpardaServiceProvider
extends AbstractAdapterServiceProvider
implements Oauth2ServiceProvider {
    private static final SpardaJwtService JWT_SERVICE = new SpardaJwtService();

    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        return new SpardaAccountInformationService(aspsp, httpClientFactory, linksRewriter, JWT_SERVICE);
    }

    public PaymentInitiationService getPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        return new SpardaPaymentInitiationService(aspsp, httpClientFactory, linksRewriter, JWT_SERVICE);
    }

    public Oauth2Service getOauth2Service(Aspsp aspsp, HttpClientFactory httpClientFactory) {
        return SpardaOauth2Service.create(aspsp, httpClientFactory, AdapterConfig.readProperty((String)"sparda.client_id"));
    }

    public String getAdapterId() {
        return "sparda-bank-adapter";
    }
}

