package de.adorsys.xs2a.adapter.santander;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.santander.model.SantanderAccountReport;
import de.adorsys.xs2a.adapter.santander.model.SantanderOK200TransactionDetails;
import de.adorsys.xs2a.adapter.santander.model.SantanderTransactionDetails;
import de.adorsys.xs2a.adapter.santander.model.SantanderTransactionResponse200Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-11-10T16:36:45+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_272 (Azul Systems, Inc.)"
)
public class SantanderMapperImpl implements SantanderMapper {

    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(SantanderTransactionResponse200Json value) {
        if ( value == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setAccount( value.getAccount() );
        transactionsResponse200Json.setTransactions( santanderAccountReportToAccountReport( value.getTransactions() ) );
        List<Balance> list = value.getBalances();
        if ( list != null ) {
            transactionsResponse200Json.setBalances( new ArrayList<Balance>( list ) );
        }
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactionsResponse200Json.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionsResponse200Json;
    }

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(SantanderOK200TransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();

        oK200TransactionDetails.setTransactionsDetails( santanderTransactionDetailsToTransactionDetails( value.getTransactionsDetails() ) );

        return oK200TransactionDetails;
    }

    protected TransactionDetails santanderTransactionDetailsToTransactionDetails(SantanderTransactionDetails santanderTransactionDetails) {
        if ( santanderTransactionDetails == null ) {
            return null;
        }

        TransactionDetails transactionDetails = new TransactionDetails();

        transactionDetails.setTransactionId( santanderTransactionDetails.getTransactionId() );
        transactionDetails.setEntryReference( santanderTransactionDetails.getEntryReference() );
        transactionDetails.setEndToEndId( santanderTransactionDetails.getEndToEndId() );
        transactionDetails.setMandateId( santanderTransactionDetails.getMandateId() );
        transactionDetails.setCheckId( santanderTransactionDetails.getCheckId() );
        transactionDetails.setCreditorId( santanderTransactionDetails.getCreditorId() );
        transactionDetails.setBookingDate( santanderTransactionDetails.getBookingDate() );
        transactionDetails.setValueDate( santanderTransactionDetails.getValueDate() );
        transactionDetails.setTransactionAmount( santanderTransactionDetails.getTransactionAmount() );
        List<ReportExchangeRate> list = santanderTransactionDetails.getCurrencyExchange();
        if ( list != null ) {
            transactionDetails.setCurrencyExchange( new ArrayList<ReportExchangeRate>( list ) );
        }
        transactionDetails.setCreditorName( santanderTransactionDetails.getCreditorName() );
        transactionDetails.setCreditorAccount( santanderTransactionDetails.getCreditorAccount() );
        transactionDetails.setCreditorAgent( santanderTransactionDetails.getCreditorAgent() );
        transactionDetails.setUltimateCreditor( santanderTransactionDetails.getUltimateCreditor() );
        transactionDetails.setDebtorName( santanderTransactionDetails.getDebtorName() );
        transactionDetails.setDebtorAccount( santanderTransactionDetails.getDebtorAccount() );
        transactionDetails.setDebtorAgent( santanderTransactionDetails.getDebtorAgent() );
        transactionDetails.setUltimateDebtor( santanderTransactionDetails.getUltimateDebtor() );
        transactionDetails.setRemittanceInformationUnstructured( santanderTransactionDetails.getRemittanceInformationUnstructured() );
        List<String> list1 = santanderTransactionDetails.getRemittanceInformationUnstructuredArray();
        if ( list1 != null ) {
            transactionDetails.setRemittanceInformationUnstructuredArray( new ArrayList<String>( list1 ) );
        }
        transactionDetails.setRemittanceInformationStructured( map( santanderTransactionDetails.getRemittanceInformationStructured() ) );
        List<RemittanceInformationStructured> list2 = santanderTransactionDetails.getRemittanceInformationStructuredArray();
        if ( list2 != null ) {
            transactionDetails.setRemittanceInformationStructuredArray( new ArrayList<RemittanceInformationStructured>( list2 ) );
        }
        transactionDetails.setAdditionalInformation( santanderTransactionDetails.getAdditionalInformation() );
        transactionDetails.setAdditionalInformationStructured( santanderTransactionDetails.getAdditionalInformationStructured() );
        transactionDetails.setPurposeCode( santanderTransactionDetails.getPurposeCode() );
        transactionDetails.setBankTransactionCode( santanderTransactionDetails.getBankTransactionCode() );
        transactionDetails.setProprietaryBankTransactionCode( santanderTransactionDetails.getProprietaryBankTransactionCode() );
        transactionDetails.setBalanceAfterTransaction( santanderTransactionDetails.getBalanceAfterTransaction() );
        Map<String, HrefType> map = santanderTransactionDetails.getLinks();
        if ( map != null ) {
            transactionDetails.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionDetails;
    }

    protected List<TransactionDetails> santanderTransactionDetailsListToTransactionDetailsList(List<SantanderTransactionDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<TransactionDetails> list1 = new ArrayList<TransactionDetails>( list.size() );
        for ( SantanderTransactionDetails santanderTransactionDetails : list ) {
            list1.add( santanderTransactionDetailsToTransactionDetails( santanderTransactionDetails ) );
        }

        return list1;
    }

    protected AccountReport santanderAccountReportToAccountReport(SantanderAccountReport santanderAccountReport) {
        if ( santanderAccountReport == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setBooked( santanderTransactionDetailsListToTransactionDetailsList( santanderAccountReport.getBooked() ) );
        accountReport.setPending( santanderTransactionDetailsListToTransactionDetailsList( santanderAccountReport.getPending() ) );
        Map<String, HrefType> map = santanderAccountReport.getLinks();
        if ( map != null ) {
            accountReport.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return accountReport;
    }
}
