package de.adorsys.xs2a.adapter.santander;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.TransactionDetailsBody;
import de.adorsys.xs2a.adapter.api.model.Transactions;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.santander.model.SantanderAccountReport;
import de.adorsys.xs2a.adapter.santander.model.SantanderOK200TransactionDetails;
import de.adorsys.xs2a.adapter.santander.model.SantanderTransactionDetails;
import de.adorsys.xs2a.adapter.santander.model.SantanderTransactionResponse200Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-13T15:06:30+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
public class SantanderMapperImpl implements SantanderMapper {

    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(SantanderTransactionResponse200Json value) {
        if ( value == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setAccount( value.getAccount() );
        transactionsResponse200Json.setTransactions( santanderAccountReportToAccountReport( value.getTransactions() ) );
        List<Balance> list = value.getBalances();
        if ( list != null ) {
            transactionsResponse200Json.setBalances( new ArrayList<Balance>( list ) );
        }
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactionsResponse200Json.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionsResponse200Json;
    }

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(SantanderOK200TransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();

        oK200TransactionDetails.setTransactionsDetails( toTransactionDetailsBody( value.getTransactionsDetails() ) );

        return oK200TransactionDetails;
    }

    @Override
    public Transactions toTransactions(SantanderTransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        Transactions transactions = new Transactions();

        transactions.setTransactionId( value.getTransactionId() );
        transactions.setEntryReference( value.getEntryReference() );
        transactions.setEndToEndId( value.getEndToEndId() );
        transactions.setMandateId( value.getMandateId() );
        transactions.setCheckId( value.getCheckId() );
        transactions.setCreditorId( value.getCreditorId() );
        transactions.setBookingDate( value.getBookingDate() );
        transactions.setValueDate( value.getValueDate() );
        transactions.setTransactionAmount( value.getTransactionAmount() );
        List<ReportExchangeRate> list = value.getCurrencyExchange();
        if ( list != null ) {
            transactions.setCurrencyExchange( new ArrayList<ReportExchangeRate>( list ) );
        }
        transactions.setCreditorName( value.getCreditorName() );
        transactions.setCreditorAccount( value.getCreditorAccount() );
        transactions.setCreditorAgent( value.getCreditorAgent() );
        transactions.setUltimateCreditor( value.getUltimateCreditor() );
        transactions.setDebtorName( value.getDebtorName() );
        transactions.setDebtorAccount( value.getDebtorAccount() );
        transactions.setDebtorAgent( value.getDebtorAgent() );
        transactions.setUltimateDebtor( value.getUltimateDebtor() );
        transactions.setRemittanceInformationUnstructured( value.getRemittanceInformationUnstructured() );
        List<String> list1 = value.getRemittanceInformationUnstructuredArray();
        if ( list1 != null ) {
            transactions.setRemittanceInformationUnstructuredArray( new ArrayList<String>( list1 ) );
        }
        transactions.setRemittanceInformationStructured( map( value.getRemittanceInformationStructured() ) );
        List<RemittanceInformationStructured> list2 = value.getRemittanceInformationStructuredArray();
        if ( list2 != null ) {
            transactions.setRemittanceInformationStructuredArray( new ArrayList<RemittanceInformationStructured>( list2 ) );
        }
        transactions.setAdditionalInformation( value.getAdditionalInformation() );
        transactions.setAdditionalInformationStructured( value.getAdditionalInformationStructured() );
        transactions.setPurposeCode( value.getPurposeCode() );
        transactions.setBankTransactionCode( value.getBankTransactionCode() );
        transactions.setProprietaryBankTransactionCode( value.getProprietaryBankTransactionCode() );
        transactions.setBalanceAfterTransaction( value.getBalanceAfterTransaction() );
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactions.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactions;
    }

    @Override
    public TransactionDetailsBody toTransactionDetailsBody(SantanderTransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        TransactionDetailsBody transactionDetailsBody = new TransactionDetailsBody();

        transactionDetailsBody.setTransactionDetails( toTransactions(value) );

        return transactionDetailsBody;
    }

    protected List<Transactions> santanderTransactionDetailsListToTransactionsList(List<SantanderTransactionDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<Transactions> list1 = new ArrayList<Transactions>( list.size() );
        for ( SantanderTransactionDetails santanderTransactionDetails : list ) {
            list1.add( toTransactions( santanderTransactionDetails ) );
        }

        return list1;
    }

    protected AccountReport santanderAccountReportToAccountReport(SantanderAccountReport santanderAccountReport) {
        if ( santanderAccountReport == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setBooked( santanderTransactionDetailsListToTransactionsList( santanderAccountReport.getBooked() ) );
        accountReport.setPending( santanderTransactionDetailsListToTransactionsList( santanderAccountReport.getPending() ) );
        Map<String, HrefType> map = santanderAccountReport.getLinks();
        if ( map != null ) {
            accountReport.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return accountReport;
    }
}
