package de.adorsys.xs2a.adapter.dab;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.dab.model.DabAccountReport;
import de.adorsys.xs2a.adapter.dab.model.DabOK200TransactionDetails;
import de.adorsys.xs2a.adapter.dab.model.DabTransactionDetails;
import de.adorsys.xs2a.adapter.dab.model.DabTransactionsResponse200Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-19T12:57:46+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_265 (Azul Systems, Inc.)"
)
public class DabMapperImpl implements DabMapper {

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(DabOK200TransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();

        oK200TransactionDetails.setTransactionsDetails( dabTransactionDetailsToTransactionDetails( value.getTransactionsDetails() ) );

        return oK200TransactionDetails;
    }

    @Override
    public RemittanceInformationStructured toRemittanceInformationStructured(String value) {
        if ( value == null ) {
            return null;
        }

        RemittanceInformationStructured remittanceInformationStructured = new RemittanceInformationStructured();

        remittanceInformationStructured.setReference( value );

        return remittanceInformationStructured;
    }

    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(DabTransactionsResponse200Json value) {
        if ( value == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setAccount( value.getAccount() );
        transactionsResponse200Json.setTransactions( dabAccountReportToAccountReport( value.getTransactions() ) );
        List<Balance> list = value.getBalances();
        if ( list != null ) {
            transactionsResponse200Json.setBalances( new ArrayList<Balance>( list ) );
        }
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactionsResponse200Json.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionsResponse200Json;
    }

    protected TransactionDetails dabTransactionDetailsToTransactionDetails(DabTransactionDetails dabTransactionDetails) {
        if ( dabTransactionDetails == null ) {
            return null;
        }

        TransactionDetails transactionDetails = new TransactionDetails();

        transactionDetails.setTransactionId( dabTransactionDetails.getTransactionId() );
        transactionDetails.setEntryReference( dabTransactionDetails.getEntryReference() );
        transactionDetails.setEndToEndId( dabTransactionDetails.getEndToEndId() );
        transactionDetails.setMandateId( dabTransactionDetails.getMandateId() );
        transactionDetails.setCheckId( dabTransactionDetails.getCheckId() );
        transactionDetails.setCreditorId( dabTransactionDetails.getCreditorId() );
        transactionDetails.setBookingDate( dabTransactionDetails.getBookingDate() );
        transactionDetails.setValueDate( dabTransactionDetails.getValueDate() );
        transactionDetails.setTransactionAmount( dabTransactionDetails.getTransactionAmount() );
        List<ReportExchangeRate> list = dabTransactionDetails.getCurrencyExchange();
        if ( list != null ) {
            transactionDetails.setCurrencyExchange( new ArrayList<ReportExchangeRate>( list ) );
        }
        transactionDetails.setCreditorName( dabTransactionDetails.getCreditorName() );
        transactionDetails.setCreditorAccount( dabTransactionDetails.getCreditorAccount() );
        transactionDetails.setCreditorAgent( dabTransactionDetails.getCreditorAgent() );
        transactionDetails.setUltimateCreditor( dabTransactionDetails.getUltimateCreditor() );
        transactionDetails.setDebtorName( dabTransactionDetails.getDebtorName() );
        transactionDetails.setDebtorAccount( dabTransactionDetails.getDebtorAccount() );
        transactionDetails.setDebtorAgent( dabTransactionDetails.getDebtorAgent() );
        transactionDetails.setUltimateDebtor( dabTransactionDetails.getUltimateDebtor() );
        transactionDetails.setRemittanceInformationUnstructured( dabTransactionDetails.getRemittanceInformationUnstructured() );
        List<String> list1 = dabTransactionDetails.getRemittanceInformationUnstructuredArray();
        if ( list1 != null ) {
            transactionDetails.setRemittanceInformationUnstructuredArray( new ArrayList<String>( list1 ) );
        }
        transactionDetails.setRemittanceInformationStructured( toRemittanceInformationStructured( dabTransactionDetails.getRemittanceInformationStructured() ) );
        List<RemittanceInformationStructured> list2 = dabTransactionDetails.getRemittanceInformationStructuredArray();
        if ( list2 != null ) {
            transactionDetails.setRemittanceInformationStructuredArray( new ArrayList<RemittanceInformationStructured>( list2 ) );
        }
        transactionDetails.setAdditionalInformation( dabTransactionDetails.getAdditionalInformation() );
        transactionDetails.setAdditionalInformationStructured( dabTransactionDetails.getAdditionalInformationStructured() );
        transactionDetails.setPurposeCode( dabTransactionDetails.getPurposeCode() );
        transactionDetails.setBankTransactionCode( dabTransactionDetails.getBankTransactionCode() );
        transactionDetails.setProprietaryBankTransactionCode( dabTransactionDetails.getProprietaryBankTransactionCode() );
        transactionDetails.setBalanceAfterTransaction( dabTransactionDetails.getBalanceAfterTransaction() );
        Map<String, HrefType> map = dabTransactionDetails.getLinks();
        if ( map != null ) {
            transactionDetails.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionDetails;
    }

    protected List<TransactionDetails> dabTransactionDetailsListToTransactionDetailsList(List<DabTransactionDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<TransactionDetails> list1 = new ArrayList<TransactionDetails>( list.size() );
        for ( DabTransactionDetails dabTransactionDetails : list ) {
            list1.add( dabTransactionDetailsToTransactionDetails( dabTransactionDetails ) );
        }

        return list1;
    }

    protected AccountReport dabAccountReportToAccountReport(DabAccountReport dabAccountReport) {
        if ( dabAccountReport == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setBooked( dabTransactionDetailsListToTransactionDetailsList( dabAccountReport.getBooked() ) );
        accountReport.setPending( dabTransactionDetailsListToTransactionDetailsList( dabAccountReport.getPending() ) );
        Map<String, HrefType> map = dabAccountReport.getLinks();
        if ( map != null ) {
            accountReport.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return accountReport;
    }
}
